/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.load;

import java.lang.reflect.Array;
import org.simpleframework.xml.load.ArrayFactory;
import org.simpleframework.xml.load.Converter;
import org.simpleframework.xml.load.PersistenceException;
import org.simpleframework.xml.load.Source;
import org.simpleframework.xml.load.Traverser;
import org.simpleframework.xml.load.Type;
import org.simpleframework.xml.stream.InputNode;
import org.simpleframework.xml.stream.OutputNode;

class CompositeArray
implements Converter {
    private final ArrayFactory factory;
    private final Traverser root;
    private final String parent;
    private final Class entry;

    public CompositeArray(Source root, Class field, Class entry, String parent) {
        this.factory = new ArrayFactory(root, field);
        this.root = new Traverser(root);
        this.parent = parent;
        this.entry = entry;
    }

    public Object read(InputNode node) throws Exception {
        Type value = this.factory.getInstance(node);
        if (!value.isReference()) {
            return this.read(node, value);
        }
        return value.getInstance();
    }

    private Object read(InputNode node, Type type) throws Exception {
        Object list = type.getInstance();
        int i = 0;
        InputNode next;
        while ((next = node.getNext()) != null) {
            if (this.parent != null) {
                next = next.getNext();
            }
            this.read(next, list, i);
            ++i;
        }
        return list;
    }

    private void read(InputNode node, Object list, int index) throws Exception {
        Object value = null;
        if (node != null) {
            value = this.root.read(node, this.entry);
        }
        Array.set(list, index, value);
    }

    public void write(OutputNode node, Object source) throws Exception {
        OutputNode child;
        int size = Array.getLength(source);
        for (int i = 0; i < size && (child = node.getChild(this.parent)) != null; ++i) {
            this.write(child, source, i);
        }
    }

    private void write(OutputNode node, Object source, int index) throws Exception {
        Object item = Array.get(source, index);
        if (item != null) {
            this.write(node, item, this.entry);
        }
        node.commit();
    }

    private void write(OutputNode node, Object item, Class entry) throws Exception {
        Class<?> type = item.getClass();
        if (!entry.isAssignableFrom(type)) {
            throw new PersistenceException("Entry %s does not match %s", type, entry);
        }
        this.root.write(node, item, entry);
    }
}

