/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.stream;

import javax.xml.stream.events.StartElement;
import org.simpleframework.xml.stream.InputNode;
import org.simpleframework.xml.stream.InputNodeMap;
import org.simpleframework.xml.stream.InputPosition;
import org.simpleframework.xml.stream.NodeMap;
import org.simpleframework.xml.stream.NodeReader;
import org.simpleframework.xml.stream.Position;

class InputElement
implements InputNode {
    private StartElement element;
    private InputNodeMap map;
    private NodeReader reader;
    private InputNode parent;

    public InputElement(InputNode parent, NodeReader reader, StartElement element) {
        this.map = new InputNodeMap(this, element);
        this.element = element;
        this.reader = reader;
        this.parent = parent;
    }

    public InputNode getParent() {
        return this.parent;
    }

    public Position getPosition() {
        return new InputPosition(this.element);
    }

    public String getName() {
        return this.element.getName().getLocalPart();
    }

    public boolean isRoot() {
        return this.reader.isRoot(this);
    }

    public boolean isElement() {
        return true;
    }

    public InputNode getAttribute(String name) {
        return this.map.get(name);
    }

    public NodeMap getAttributes() {
        return this.map;
    }

    public String getValue() throws Exception {
        return this.reader.readValue(this);
    }

    public InputNode getNext() throws Exception {
        return this.reader.readElement(this);
    }

    public InputNode getNext(String name) throws Exception {
        return this.reader.readElement(this, name);
    }

    public void skip() throws Exception {
        this.reader.skipElement(this);
    }
}

