/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.transform.sql;

import java.sql.Time;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import org.simpleframework.xml.transform.Transform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeTransform
implements Transform<Time> {
    private static final String FORMAT = "yyyy-MM-dd HH:mm:ss.S z";
    private final DateFormat format;

    public TimeTransform() {
        this(FORMAT);
    }

    public TimeTransform(String format) {
        this.format = new SimpleDateFormat(format);
    }

    @Override
    public synchronized Time read(String date) throws Exception {
        long time = this.readTime(date);
        return new Time(time);
    }

    private synchronized long readTime(String date) throws Exception {
        return this.format.parse(date).getTime();
    }

    @Override
    public synchronized String write(Time date) throws Exception {
        return this.format.format(date);
    }
}

