/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.helpers;

import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;

public class MessageFormatterTest {
    Integer i1 = 1;
    Integer i2 = 2;
    Integer i3 = 3;
    Integer[] ia0 = new Integer[]{this.i1, this.i2, this.i3};
    Integer[] ia1 = new Integer[]{10, 20, 30};
    String result;

    @Test
    public void testNull() {
        this.result = MessageFormatter.format(null, (Object)this.i1).getMessage();
        Assert.assertEquals(null, (Object)this.result);
    }

    @Test
    public void testParamaterContainingAnAnchor() {
        this.result = MessageFormatter.format((String)"Value is {}.", (Object)"[{}]").getMessage();
        Assert.assertEquals((Object)"Value is [{}].", (Object)this.result);
        this.result = MessageFormatter.format((String)"Values are {} and {}.", (Object)this.i1, (Object)"[{}]").getMessage();
        Assert.assertEquals((Object)"Values are 1 and [{}].", (Object)this.result);
    }

    @Test
    public void nullParametersShouldBeHandledWithoutBarfing() {
        this.result = MessageFormatter.format((String)"Value is {}.", null).getMessage();
        Assert.assertEquals((Object)"Value is null.", (Object)this.result);
        this.result = MessageFormatter.format((String)"Val1 is {}, val2 is {}.", null, null).getMessage();
        Assert.assertEquals((Object)"Val1 is null, val2 is null.", (Object)this.result);
        this.result = MessageFormatter.format((String)"Val1 is {}, val2 is {}.", (Object)this.i1, null).getMessage();
        Assert.assertEquals((Object)"Val1 is 1, val2 is null.", (Object)this.result);
        this.result = MessageFormatter.format((String)"Val1 is {}, val2 is {}.", null, (Object)this.i2).getMessage();
        Assert.assertEquals((Object)"Val1 is null, val2 is 2.", (Object)this.result);
        this.result = MessageFormatter.arrayFormat((String)"Val1 is {}, val2 is {}, val3 is {}", (Object[])new Integer[]{null, null, null}).getMessage();
        Assert.assertEquals((Object)"Val1 is null, val2 is null, val3 is null", (Object)this.result);
        this.result = MessageFormatter.arrayFormat((String)"Val1 is {}, val2 is {}, val3 is {}", (Object[])new Integer[]{null, this.i2, this.i3}).getMessage();
        Assert.assertEquals((Object)"Val1 is null, val2 is 2, val3 is 3", (Object)this.result);
        this.result = MessageFormatter.arrayFormat((String)"Val1 is {}, val2 is {}, val3 is {}", (Object[])new Integer[]{null, null, this.i3}).getMessage();
        Assert.assertEquals((Object)"Val1 is null, val2 is null, val3 is 3", (Object)this.result);
    }

    @Test
    public void verifyOneParameterIsHandledCorrectly() {
        this.result = MessageFormatter.format((String)"Value is {}.", (Object)this.i3).getMessage();
        Assert.assertEquals((Object)"Value is 3.", (Object)this.result);
        this.result = MessageFormatter.format((String)"Value is {", (Object)this.i3).getMessage();
        Assert.assertEquals((Object)"Value is {", (Object)this.result);
        this.result = MessageFormatter.format((String)"{} is larger than 2.", (Object)this.i3).getMessage();
        Assert.assertEquals((Object)"3 is larger than 2.", (Object)this.result);
        this.result = MessageFormatter.format((String)"No subst", (Object)this.i3).getMessage();
        Assert.assertEquals((Object)"No subst", (Object)this.result);
        this.result = MessageFormatter.format((String)"Incorrect {subst", (Object)this.i3).getMessage();
        Assert.assertEquals((Object)"Incorrect {subst", (Object)this.result);
        this.result = MessageFormatter.format((String)"Value is {bla} {}", (Object)this.i3).getMessage();
        Assert.assertEquals((Object)"Value is {bla} 3", (Object)this.result);
        this.result = MessageFormatter.format((String)"Escaped \\{} subst", (Object)this.i3).getMessage();
        Assert.assertEquals((Object)"Escaped {} subst", (Object)this.result);
        this.result = MessageFormatter.format((String)"{Escaped", (Object)this.i3).getMessage();
        Assert.assertEquals((Object)"{Escaped", (Object)this.result);
        this.result = MessageFormatter.format((String)"\\{}Escaped", (Object)this.i3).getMessage();
        Assert.assertEquals((Object)"{}Escaped", (Object)this.result);
        this.result = MessageFormatter.format((String)"File name is {{}}.", (Object)"App folder.zip").getMessage();
        Assert.assertEquals((Object)"File name is {App folder.zip}.", (Object)this.result);
        this.result = MessageFormatter.format((String)"File name is C:\\\\{}.", (Object)"App folder.zip").getMessage();
        Assert.assertEquals((Object)"File name is C:\\App folder.zip.", (Object)this.result);
    }

    @Test
    public void testTwoParameters() {
        this.result = MessageFormatter.format((String)"Value {} is smaller than {}.", (Object)this.i1, (Object)this.i2).getMessage();
        Assert.assertEquals((Object)"Value 1 is smaller than 2.", (Object)this.result);
        this.result = MessageFormatter.format((String)"Value {} is smaller than {}", (Object)this.i1, (Object)this.i2).getMessage();
        Assert.assertEquals((Object)"Value 1 is smaller than 2", (Object)this.result);
        this.result = MessageFormatter.format((String)"{}{}", (Object)this.i1, (Object)this.i2).getMessage();
        Assert.assertEquals((Object)"12", (Object)this.result);
        this.result = MessageFormatter.format((String)"Val1={}, Val2={", (Object)this.i1, (Object)this.i2).getMessage();
        Assert.assertEquals((Object)"Val1=1, Val2={", (Object)this.result);
        this.result = MessageFormatter.format((String)"Value {} is smaller than \\{}", (Object)this.i1, (Object)this.i2).getMessage();
        Assert.assertEquals((Object)"Value 1 is smaller than {}", (Object)this.result);
        this.result = MessageFormatter.format((String)"Value {} is smaller than \\{} tail", (Object)this.i1, (Object)this.i2).getMessage();
        Assert.assertEquals((Object)"Value 1 is smaller than {} tail", (Object)this.result);
        this.result = MessageFormatter.format((String)"Value {} is smaller than \\{", (Object)this.i1, (Object)this.i2).getMessage();
        Assert.assertEquals((Object)"Value 1 is smaller than \\{", (Object)this.result);
        this.result = MessageFormatter.format((String)"Value {} is smaller than {tail", (Object)this.i1, (Object)this.i2).getMessage();
        Assert.assertEquals((Object)"Value 1 is smaller than {tail", (Object)this.result);
        this.result = MessageFormatter.format((String)"Value \\{} is smaller than {}", (Object)this.i1, (Object)this.i2).getMessage();
        Assert.assertEquals((Object)"Value {} is smaller than 1", (Object)this.result);
    }

    @Test
    public void testExceptionIn_toString() {
        Object o = new Object(){

            public String toString() {
                throw new IllegalStateException("a");
            }
        };
        this.result = MessageFormatter.format((String)"Troublesome object {}", (Object)o).getMessage();
        Assert.assertEquals((Object)"Troublesome object [FAILED toString()]", (Object)this.result);
    }

    @Test
    public void testNullArray() {
        String msg0 = "msg0";
        String msg1 = "msg1 {}";
        String msg2 = "msg2 {} {}";
        String msg3 = "msg3 {} {} {}";
        Object[] args = null;
        this.result = MessageFormatter.arrayFormat((String)msg0, args).getMessage();
        Assert.assertEquals((Object)msg0, (Object)this.result);
        this.result = MessageFormatter.arrayFormat((String)msg1, args).getMessage();
        Assert.assertEquals((Object)msg1, (Object)this.result);
        this.result = MessageFormatter.arrayFormat((String)msg2, args).getMessage();
        Assert.assertEquals((Object)msg2, (Object)this.result);
        this.result = MessageFormatter.arrayFormat((String)msg3, args).getMessage();
        Assert.assertEquals((Object)msg3, (Object)this.result);
    }

    @Test
    public void testArrayFormat() {
        this.result = MessageFormatter.arrayFormat((String)"Value {} is smaller than {} and {}.", (Object[])this.ia0).getMessage();
        Assert.assertEquals((Object)"Value 1 is smaller than 2 and 3.", (Object)this.result);
        this.result = MessageFormatter.arrayFormat((String)"{}{}{}", (Object[])this.ia0).getMessage();
        Assert.assertEquals((Object)"123", (Object)this.result);
        this.result = MessageFormatter.arrayFormat((String)"Value {} is smaller than {}.", (Object[])this.ia0).getMessage();
        Assert.assertEquals((Object)"Value 1 is smaller than 2.", (Object)this.result);
        this.result = MessageFormatter.arrayFormat((String)"Value {} is smaller than {}", (Object[])this.ia0).getMessage();
        Assert.assertEquals((Object)"Value 1 is smaller than 2", (Object)this.result);
        this.result = MessageFormatter.arrayFormat((String)"Val={}, {, Val={}", (Object[])this.ia0).getMessage();
        Assert.assertEquals((Object)"Val=1, {, Val=2", (Object)this.result);
        this.result = MessageFormatter.arrayFormat((String)"Val={}, {, Val={}", (Object[])this.ia0).getMessage();
        Assert.assertEquals((Object)"Val=1, {, Val=2", (Object)this.result);
        this.result = MessageFormatter.arrayFormat((String)"Val1={}, Val2={", (Object[])this.ia0).getMessage();
        Assert.assertEquals((Object)"Val1=1, Val2={", (Object)this.result);
    }

    @Test
    public void testArrayValues() {
        Integer p0 = this.i1;
        Integer[] p1 = new Integer[]{this.i2, this.i3};
        this.result = MessageFormatter.format((String)"{}{}", (Object)p0, (Object)p1).getMessage();
        Assert.assertEquals((Object)"1[2, 3]", (Object)this.result);
        this.result = MessageFormatter.arrayFormat((String)"{}{}", (Object[])new Object[]{"a", p1}).getMessage();
        Assert.assertEquals((Object)"a[2, 3]", (Object)this.result);
        this.result = MessageFormatter.arrayFormat((String)"{}{}", (Object[])new Object[]{"a", new byte[]{1, 2}}).getMessage();
        Assert.assertEquals((Object)"a[1, 2]", (Object)this.result);
        this.result = MessageFormatter.arrayFormat((String)"{}{}", (Object[])new Object[]{"a", new int[]{1, 2}}).getMessage();
        Assert.assertEquals((Object)"a[1, 2]", (Object)this.result);
        this.result = MessageFormatter.arrayFormat((String)"{}{}", (Object[])new Object[]{"a", new float[]{1.0f, 2.0f}}).getMessage();
        Assert.assertEquals((Object)"a[1.0, 2.0]", (Object)this.result);
        this.result = MessageFormatter.arrayFormat((String)"{}{}", (Object[])new Object[]{"a", new double[]{1.0, 2.0}}).getMessage();
        Assert.assertEquals((Object)"a[1.0, 2.0]", (Object)this.result);
    }

    @Test
    public void testMultiDimensionalArrayValues() {
        Integer[][] multiIntegerA = new Integer[][]{this.ia0, this.ia1};
        this.result = MessageFormatter.arrayFormat((String)"{}{}", (Object[])new Object[]{"a", multiIntegerA}).getMessage();
        Assert.assertEquals((Object)"a[[1, 2, 3], [10, 20, 30]]", (Object)this.result);
        int[][] multiIntA = new int[][]{{1, 2}, {10, 20}};
        this.result = MessageFormatter.arrayFormat((String)"{}{}", (Object[])new Object[]{"a", multiIntA}).getMessage();
        Assert.assertEquals((Object)"a[[1, 2], [10, 20]]", (Object)this.result);
        float[][] multiFloatA = new float[][]{{1.0f, 2.0f}, {10.0f, 20.0f}};
        this.result = MessageFormatter.arrayFormat((String)"{}{}", (Object[])new Object[]{"a", multiFloatA}).getMessage();
        Assert.assertEquals((Object)"a[[1.0, 2.0], [10.0, 20.0]]", (Object)this.result);
        Object[][] multiOA = new Object[][]{this.ia0, this.ia1};
        this.result = MessageFormatter.arrayFormat((String)"{}{}", (Object[])new Object[]{"a", multiOA}).getMessage();
        Assert.assertEquals((Object)"a[[1, 2, 3], [10, 20, 30]]", (Object)this.result);
        Object[][][] _3DOA = new Object[][][]{multiOA, multiOA};
        this.result = MessageFormatter.arrayFormat((String)"{}{}", (Object[])new Object[]{"a", _3DOA}).getMessage();
        Assert.assertEquals((Object)"a[[[1, 2, 3], [10, 20, 30]], [[1, 2, 3], [10, 20, 30]]]", (Object)this.result);
    }

    @Test
    public void testCyclicArrays() {
        Object[] b;
        Object[] cyclicA;
        cyclicA[0] = cyclicA = new Object[1];
        Assert.assertEquals((Object)"[[...]]", (Object)MessageFormatter.arrayFormat((String)"{}", (Object[])cyclicA).getMessage());
        Object[] a = new Object[2];
        a[0] = this.i1;
        Object[] c = new Object[]{this.i3, a};
        a[1] = b = new Object[]{this.i2, c};
        Assert.assertEquals((Object)"1[2, [3, [1, [...]]]]", (Object)MessageFormatter.arrayFormat((String)"{}{}", (Object[])a).getMessage());
    }

    @Test
    public void testArrayThrowable() {
        Throwable t = new Throwable();
        Object[] ia = new Object[]{this.i1, this.i2, this.i3, t};
        Object[] iaWitness = new Object[]{this.i1, this.i2, this.i3};
        FormattingTuple ft = MessageFormatter.arrayFormat((String)"Value {} is smaller than {} and {}.", (Object[])ia);
        Assert.assertEquals((Object)"Value 1 is smaller than 2 and 3.", (Object)ft.getMessage());
        Assert.assertTrue((boolean)Arrays.equals(iaWitness, ft.getArgArray()));
        Assert.assertEquals((Object)t, (Object)ft.getThrowable());
        ft = MessageFormatter.arrayFormat((String)"{}{}{}", (Object[])ia);
        Assert.assertEquals((Object)"123", (Object)ft.getMessage());
        Assert.assertTrue((boolean)Arrays.equals(iaWitness, ft.getArgArray()));
        Assert.assertEquals((Object)t, (Object)ft.getThrowable());
        ft = MessageFormatter.arrayFormat((String)"Value {} is smaller than {}.", (Object[])ia);
        Assert.assertEquals((Object)"Value 1 is smaller than 2.", (Object)ft.getMessage());
        Assert.assertTrue((boolean)Arrays.equals(iaWitness, ft.getArgArray()));
        Assert.assertEquals((Object)t, (Object)ft.getThrowable());
        ft = MessageFormatter.arrayFormat((String)"Value {} is smaller than {}", (Object[])ia);
        Assert.assertEquals((Object)"Value 1 is smaller than 2", (Object)ft.getMessage());
        Assert.assertTrue((boolean)Arrays.equals(iaWitness, ft.getArgArray()));
        Assert.assertEquals((Object)t, (Object)ft.getThrowable());
        ft = MessageFormatter.arrayFormat((String)"Val={}, {, Val={}", (Object[])ia);
        Assert.assertEquals((Object)"Val=1, {, Val=2", (Object)ft.getMessage());
        Assert.assertTrue((boolean)Arrays.equals(iaWitness, ft.getArgArray()));
        Assert.assertEquals((Object)t, (Object)ft.getThrowable());
        ft = MessageFormatter.arrayFormat((String)"Val={}, \\{, Val={}", (Object[])ia);
        Assert.assertEquals((Object)"Val=1, \\{, Val=2", (Object)ft.getMessage());
        Assert.assertTrue((boolean)Arrays.equals(iaWitness, ft.getArgArray()));
        Assert.assertEquals((Object)t, (Object)ft.getThrowable());
        ft = MessageFormatter.arrayFormat((String)"Val1={}, Val2={", (Object[])ia);
        Assert.assertEquals((Object)"Val1=1, Val2={", (Object)ft.getMessage());
        Assert.assertTrue((boolean)Arrays.equals(iaWitness, ft.getArgArray()));
        Assert.assertEquals((Object)t, (Object)ft.getThrowable());
        ft = MessageFormatter.arrayFormat((String)"Value {} is smaller than {} and {}.", (Object[])ia);
        Assert.assertEquals((Object)"Value 1 is smaller than 2 and 3.", (Object)ft.getMessage());
        Assert.assertTrue((boolean)Arrays.equals(iaWitness, ft.getArgArray()));
        Assert.assertEquals((Object)t, (Object)ft.getThrowable());
        ft = MessageFormatter.arrayFormat((String)"{}{}{}{}", (Object[])ia);
        Assert.assertEquals((Object)"123{}", (Object)ft.getMessage());
        Assert.assertTrue((boolean)Arrays.equals(iaWitness, ft.getArgArray()));
        Assert.assertEquals((Object)t, (Object)ft.getThrowable());
        ft = MessageFormatter.arrayFormat((String)"1={}", (Object[])new Object[]{this.i1}, (Throwable)t);
        Assert.assertEquals((Object)"1=1", (Object)ft.getMessage());
        Assert.assertTrue((boolean)Arrays.equals(new Object[]{this.i1}, ft.getArgArray()));
        Assert.assertEquals((Object)t, (Object)ft.getThrowable());
    }
}

