/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.CheckForNull;
import org.sonar.check.Rule;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.matcher.MethodMatcherCollection;
import org.sonar.java.matcher.TypeCriteria;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.ParenthesizedTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeCastTree;
import org.sonar.plugins.java.api.tree.UnaryExpressionTree;

@Rule(key="S2676")
public class AbsOnNegativeCheck
extends IssuableSubscriptionVisitor {
    private static final MethodMatcherCollection MATH_ABS_METHODS = MethodMatcherCollection.create((MethodMatcher[])new MethodMatcher[]{MethodMatcher.create().typeDefinition("java.lang.Math").name("abs").addParameter("int"), MethodMatcher.create().typeDefinition("java.lang.Math").name("abs").addParameter("long")});
    private static final MethodMatcherCollection NEGATIVE_METHODS = MethodMatcherCollection.create((MethodMatcher[])new MethodMatcher[]{MethodMatcher.create().name("hashCode"), MethodMatcher.create().typeDefinition(TypeCriteria.subtypeOf((String)"java.util.Random")).name("nextInt"), MethodMatcher.create().typeDefinition(TypeCriteria.subtypeOf((String)"java.util.Random")).name("nextLong"), MethodMatcher.create().typeDefinition(TypeCriteria.subtypeOf((String)"java.lang.Comparable")).name("compareTo").addParameter(TypeCriteria.anyType())});

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.METHOD_INVOCATION, (Object)Tree.Kind.UNARY_MINUS);
    }

    public void visitNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
            MethodInvocationTree methodTree = (MethodInvocationTree)tree;
            if (MATH_ABS_METHODS.anyMatch(methodTree)) {
                ExpressionTree firstArgument = (ExpressionTree)methodTree.arguments().get(0);
                this.checkForIssue(firstArgument);
            }
        } else {
            ExpressionTree operand = ((UnaryExpressionTree)tree).expression();
            this.checkForIssue(operand);
        }
    }

    private void checkForIssue(ExpressionTree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            Symbol identifierSymbol = ((MemberSelectExpressionTree)tree).identifier().symbol();
            Type ownerType = identifierSymbol.owner().type();
            if ("MIN_VALUE".equals(identifierSymbol.name()) && (ownerType.is("java.lang.Integer") || ownerType.is("java.lang.Long"))) {
                this.reportIssue((Tree)tree, "Use the original value instead.");
            }
        } else {
            MethodInvocationTree nestedTree = AbsOnNegativeCheck.extractMethodInvocation(tree);
            if (nestedTree != null && NEGATIVE_METHODS.anyMatch(nestedTree)) {
                this.reportIssue((Tree)nestedTree, "Use the original value instead.");
            }
        }
    }

    @CheckForNull
    private static MethodInvocationTree extractMethodInvocation(ExpressionTree tree) {
        ExpressionTree result = tree;
        while (true) {
            if (result.is(new Tree.Kind[]{Tree.Kind.TYPE_CAST})) {
                result = ((TypeCastTree)result).expression();
                continue;
            }
            if (!result.is(new Tree.Kind[]{Tree.Kind.PARENTHESIZED_EXPRESSION})) break;
            result = ((ParenthesizedTree)result).expression();
        }
        if (result.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
            return (MethodInvocationTree)result;
        }
        return null;
    }
}

