/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.resolve.ParametrizedTypeJavaType;
import org.sonar.java.resolve.TypeVariableJavaType;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2141")
public class ClassWithoutHashCodeInHashStructureCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.NEW_CLASS);
    }

    public void visitNode(Tree tree) {
        ParametrizedTypeJavaType ptt;
        Symbol.TypeSymbol symbol;
        if (!this.hasSemantic()) {
            return;
        }
        Type type = ((NewClassTree)tree).symbolType();
        if (type instanceof ParametrizedTypeJavaType && ClassWithoutHashCodeInHashStructureCheck.useHashDataStructure(type) && ClassWithoutHashCodeInHashStructureCheck.implementsEquals(symbol = (ptt = (ParametrizedTypeJavaType)type).substitution((TypeVariableJavaType)ptt.typeParameters().get(0)).symbol()) && !ClassWithoutHashCodeInHashStructureCheck.implementsHashCode(symbol)) {
            this.reportIssue(tree, "Add a \"hashCode()\" method to \"" + symbol.name() + "\" or remove it from this hash.");
        }
    }

    private static boolean useHashDataStructure(Type type) {
        return type.isSubtypeOf("java.util.HashMap") || type.isSubtypeOf("java.util.HashSet") || type.isSubtypeOf("java.util.Hashtable");
    }

    private static boolean implementsEquals(Symbol.TypeSymbol symbol) {
        for (Symbol equals : symbol.lookupSymbols("equals")) {
            List params;
            if (!equals.isMethodSymbol() || (params = ((Symbol.MethodSymbol)equals).parameterTypes()).size() != 1 || !((Type)params.get(0)).is("java.lang.Object")) continue;
            return true;
        }
        return false;
    }

    private static boolean implementsHashCode(Symbol.TypeSymbol symbol) {
        for (Symbol hashCode : symbol.lookupSymbols("hashCode")) {
            if (!hashCode.isMethodSymbol() || !((Symbol.MethodSymbol)hashCode).parameterTypes().isEmpty()) continue;
            return true;
        }
        return false;
    }
}

