/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.check.Rule;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.matcher.TypeCriteria;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1155")
public class CollectionIsEmptyCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private static final String JAVA_UTIL_COLLECTION = "java.util.Collection";
    private static final MethodMatcher SIZE_METHOD = CollectionIsEmptyCheck.getSizeMethodInvocationMatcher();
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitClass(ClassTree tree) {
        for (Tree member : tree.members()) {
            if (tree.symbol().type().isSubtypeOf(JAVA_UTIL_COLLECTION) && member.is(new Tree.Kind[]{Tree.Kind.METHOD})) continue;
            this.scan(member);
        }
    }

    public void visitBinaryExpression(BinaryExpressionTree tree) {
        super.visitBinaryExpression(tree);
        if (CollectionIsEmptyCheck.hasCallToSizeMethod(tree) && CollectionIsEmptyCheck.isEmptyComparison(tree)) {
            this.context.reportIssue((JavaCheck)this, (Tree)tree, "Use isEmpty() to check whether the collection is empty or not.");
        }
    }

    private static boolean hasCallToSizeMethod(BinaryExpressionTree tree) {
        return CollectionIsEmptyCheck.isCallToSizeMethod(tree.leftOperand()) || CollectionIsEmptyCheck.isCallToSizeMethod(tree.rightOperand());
    }

    private static boolean isCallToSizeMethod(ExpressionTree tree) {
        if (!tree.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
            return false;
        }
        return SIZE_METHOD.matches((MethodInvocationTree)tree);
    }

    private static boolean isEmptyComparison(BinaryExpressionTree tree) {
        boolean result = CollectionIsEmptyCheck.isEqualityExpression(tree) ? CollectionIsEmptyCheck.isZero(tree.leftOperand()) || CollectionIsEmptyCheck.isZero(tree.rightOperand()) : (tree.is(new Tree.Kind[]{Tree.Kind.GREATER_THAN_OR_EQUAL_TO}) || tree.is(new Tree.Kind[]{Tree.Kind.LESS_THAN}) ? CollectionIsEmptyCheck.isZero(tree.leftOperand()) || CollectionIsEmptyCheck.isOne(tree.rightOperand()) : (tree.is(new Tree.Kind[]{Tree.Kind.GREATER_THAN}) || tree.is(new Tree.Kind[]{Tree.Kind.LESS_THAN_OR_EQUAL_TO}) ? CollectionIsEmptyCheck.isOne(tree.leftOperand()) || CollectionIsEmptyCheck.isZero(tree.rightOperand()) : false));
        return result;
    }

    private static boolean isEqualityExpression(BinaryExpressionTree tree) {
        return tree.is(new Tree.Kind[]{Tree.Kind.EQUAL_TO}) || tree.is(new Tree.Kind[]{Tree.Kind.NOT_EQUAL_TO});
    }

    private static boolean isZero(ExpressionTree tree) {
        return tree.is(new Tree.Kind[]{Tree.Kind.INT_LITERAL}) && "0".equals(((LiteralTree)tree).value());
    }

    private static boolean isOne(ExpressionTree tree) {
        return tree.is(new Tree.Kind[]{Tree.Kind.INT_LITERAL}) && "1".equals(((LiteralTree)tree).value());
    }

    private static MethodMatcher getSizeMethodInvocationMatcher() {
        return MethodMatcher.create().typeDefinition(TypeCriteria.subtypeOf((String)JAVA_UTIL_COLLECTION)).name("size").withNoParameterConstraint();
    }
}

