/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.model.LiteralUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S2068")
public class HardCodedCredentialsCheck
extends IssuableSubscriptionVisitor {
    private static final Pattern PASSWORD_LITERAL_PATTERN = Pattern.compile("(password|passwd|pwd)=..", 2);
    private static final Pattern PASSWORD_VARIABLE_PATTERN = Pattern.compile("(password|passwd|pwd)", 2);
    private static final MethodMatcher PASSWORD_AUTHENTICATION_CONSTRUCTOR = MethodMatcher.create().typeDefinition("java.net.PasswordAuthentication").name("<init>").addParameter("java.lang.String").addParameter("char[]");
    private static final MethodMatcher STRING_TO_CHAR_ARRAY = MethodMatcher.create().typeDefinition("java.lang.String").name("toCharArray").withNoParameterConstraint();

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.STRING_LITERAL, (Object)Tree.Kind.VARIABLE, (Object)Tree.Kind.ASSIGNMENT, (Object)Tree.Kind.NEW_CLASS, (Object)Tree.Kind.METHOD_INVOCATION);
    }

    public void visitNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL})) {
            this.handleStringLiteral((LiteralTree)tree);
        } else if (tree.is(new Tree.Kind[]{Tree.Kind.VARIABLE})) {
            this.handleVariable((VariableTree)tree);
        } else if (tree.is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT})) {
            this.handleAssignement((AssignmentExpressionTree)tree);
        } else if (tree.is(new Tree.Kind[]{Tree.Kind.NEW_CLASS})) {
            this.handleConstructor((NewClassTree)tree);
        } else {
            this.handleMethodInvocation((MethodInvocationTree)tree);
        }
    }

    private void handleStringLiteral(LiteralTree tree) {
        if (PASSWORD_LITERAL_PATTERN.matcher(tree.value()).find()) {
            this.reportIssue((Tree)tree);
        }
    }

    private void handleVariable(VariableTree tree) {
        IdentifierTree simpleName = tree.simpleName();
        if (HardCodedCredentialsCheck.isStringLiteral(tree.initializer()) && HardCodedCredentialsCheck.isPasswordVariableName(simpleName)) {
            this.reportIssue((Tree)simpleName);
        }
    }

    private void handleAssignement(AssignmentExpressionTree tree) {
        ExpressionTree variable = tree.variable();
        if (HardCodedCredentialsCheck.isStringLiteral(tree.expression()) && HardCodedCredentialsCheck.isPasswordVariable(variable)) {
            this.reportIssue((Tree)variable);
        }
    }

    private void handleConstructor(NewClassTree tree) {
        MethodInvocationTree mit;
        if (!PASSWORD_AUTHENTICATION_CONSTRUCTOR.matches(tree)) {
            return;
        }
        ExpressionTree secondArg = (ExpressionTree)tree.arguments().get(1);
        if (secondArg.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION}) && HardCodedCredentialsCheck.isCallOnStringLiteral((mit = (MethodInvocationTree)secondArg).methodSelect()) && STRING_TO_CHAR_ARRAY.matches(mit)) {
            this.reportIssue((Tree)secondArg);
        }
    }

    private static boolean isCallOnStringLiteral(ExpressionTree expr) {
        return expr.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT}) && ((MemberSelectExpressionTree)expr).expression().is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL});
    }

    private void handleMethodInvocation(MethodInvocationTree tree) {
        if (HardCodedCredentialsCheck.isSettingPassword(tree)) {
            this.reportIssue((Tree)tree.methodSelect());
        }
    }

    private static boolean isSettingPassword(MethodInvocationTree tree) {
        Arguments arguments = tree.arguments();
        return arguments.size() == 2 && HardCodedCredentialsCheck.argumentsAreLiterals((List<ExpressionTree>)arguments) && HardCodedCredentialsCheck.isPassword((LiteralTree)arguments.get(0));
    }

    private static boolean isPassword(LiteralTree argument) {
        return argument.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL}) && PASSWORD_VARIABLE_PATTERN.matcher(LiteralUtils.trimQuotes((String)argument.value())).matches();
    }

    private static boolean argumentsAreLiterals(List<ExpressionTree> arguments) {
        for (ExpressionTree argument : arguments) {
            if (argument.is(new Tree.Kind[]{Tree.Kind.INT_LITERAL, Tree.Kind.LONG_LITERAL, Tree.Kind.FLOAT_LITERAL, Tree.Kind.DOUBLE_LITERAL, Tree.Kind.BOOLEAN_LITERAL, Tree.Kind.CHAR_LITERAL, Tree.Kind.STRING_LITERAL, Tree.Kind.NULL_LITERAL})) continue;
            return false;
        }
        return true;
    }

    private static boolean isStringLiteral(@Nullable ExpressionTree initializer) {
        return initializer != null && initializer.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL});
    }

    private static boolean isPasswordVariableName(IdentifierTree identifierTree) {
        return PASSWORD_VARIABLE_PATTERN.matcher(identifierTree.name()).find();
    }

    private static boolean isPasswordVariable(ExpressionTree variable) {
        if (variable.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            return HardCodedCredentialsCheck.isPasswordVariableName(((MemberSelectExpressionTree)variable).identifier());
        }
        if (variable.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            return HardCodedCredentialsCheck.isPasswordVariableName((IdentifierTree)variable);
        }
        return false;
    }

    private void reportIssue(Tree tree) {
        this.reportIssue(tree, "Remove this hard-coded password.");
    }
}

