/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.model.LiteralUtils;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2639")
public class InappropriateRegexpCheck
extends AbstractMethodDetection {
    private static final String INAPPROPRIATE_REGEXPS = "\\.|\\|";

    @Override
    protected List<MethodMatcher> getMethodInvocationMatchers() {
        return ImmutableList.of((Object)MethodMatcher.create().typeDefinition("java.lang.String").name("replaceAll").withNoParameterConstraint());
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        ExpressionTree firstArg = (ExpressionTree)mit.arguments().get(0);
        if (InappropriateRegexpCheck.isInappropriateRegexpStringLiteral(firstArg) || InappropriateRegexpCheck.isFileSeparator(firstArg)) {
            this.reportIssue((Tree)firstArg, "Correct this regular expression.");
        }
    }

    private static boolean isInappropriateRegexpStringLiteral(ExpressionTree firstArg) {
        if (firstArg.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL})) {
            String regexp = LiteralUtils.trimQuotes((String)((LiteralTree)firstArg).value());
            return regexp.matches(INAPPROPRIATE_REGEXPS);
        }
        return false;
    }

    private static boolean isFileSeparator(ExpressionTree firstArg) {
        if (firstArg.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            MemberSelectExpressionTree mse = (MemberSelectExpressionTree)firstArg;
            return "separator".equals(mse.identifier().name()) && mse.expression().symbolType().is("java.io.File");
        }
        return false;
    }
}

