/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.check.Rule;
import org.sonar.java.checks.AbstractInjectionChecker;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.matcher.TypeCriteria;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewArrayTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2078")
public class LDAPInjectionCheck
extends AbstractInjectionChecker {
    private static final MethodMatcher LDAP_SEARCH_MATCHER = MethodMatcher.create().typeDefinition(TypeCriteria.subtypeOf((String)"javax.naming.directory.DirContext")).name("search").withNoParameterConstraint();
    private static final MethodMatcher SEARCH_CONTROLS_MATCHER = MethodMatcher.create().typeDefinition("javax.naming.directory.SearchControls").name("setReturningAttributes").addParameter("java.lang.String[]");

    public void visitNode(Tree tree) {
        ExpressionTree arg;
        MethodInvocationTree mit = (MethodInvocationTree)tree;
        if (this.isDirContextSearchCall(mit)) {
            this.checkDirContextArg((ExpressionTree)mit.arguments().get(0), mit);
            this.checkDirContextArg((ExpressionTree)mit.arguments().get(1), mit);
        } else if (this.isSearchControlCall(mit) && this.isDynamicArray(arg = (ExpressionTree)mit.arguments().get(0), mit)) {
            this.reportIssue((Tree)arg, "Make sure that \"" + this.parameterName + "\" is sanitized before use in this LDAP request.");
        }
    }

    private void checkDirContextArg(ExpressionTree arg1, MethodInvocationTree mit) {
        if (arg1.symbolType().is("java.lang.String") && this.isDynamicString((Tree)mit, arg1, null)) {
            this.reportIssue((Tree)arg1, "Make sure that \"" + this.parameterName + "\" is sanitized before use in this LDAP request.");
        }
    }

    private boolean isDynamicArray(ExpressionTree arg, MethodInvocationTree mit) {
        if (arg.is(new Tree.Kind[]{Tree.Kind.NEW_ARRAY})) {
            NewArrayTree nat = (NewArrayTree)arg;
            for (ExpressionTree expressionTree : nat.initializers()) {
                if (!this.isDynamicString((Tree)mit, expressionTree, null)) continue;
                return true;
            }
            return false;
        }
        this.setParameterNameFromArgument(arg);
        return true;
    }

    private boolean isDirContextSearchCall(MethodInvocationTree methodTree) {
        return this.hasSemantic() && LDAP_SEARCH_MATCHER.matches(methodTree);
    }

    private boolean isSearchControlCall(MethodInvocationTree methodTree) {
        return this.hasSemantic() && SEARCH_CONTROLS_MATCHER.matches(methodTree);
    }
}

