/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.io.File;
import org.sonar.check.Rule;
import org.sonar.java.model.PackageUtils;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.CompilationUnitTree;
import org.sonar.plugins.java.api.tree.PackageDeclarationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1598")
public class MismatchPackageDirectoryCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitCompilationUnit(CompilationUnitTree tree) {
        PackageDeclarationTree packageDeclaration = tree.packageDeclaration();
        if (packageDeclaration != null) {
            String packageName = PackageUtils.packageName((PackageDeclarationTree)packageDeclaration, (String)File.separator);
            File javaFile = this.context.getFile();
            String dir = javaFile.getParent();
            if (!dir.endsWith(packageName)) {
                this.context.reportIssue((JavaCheck)this, (Tree)packageDeclaration.packageName(), "This file \"" + javaFile.getName() + "\" should be located in \"" + packageName + "\" directory, not in \"" + dir + "\".");
            }
        }
    }
}

