/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.DoWhileStatementTree;
import org.sonar.plugins.java.api.tree.ForEachStatement;
import org.sonar.plugins.java.api.tree.ForStatementTree;
import org.sonar.plugins.java.api.tree.IfStatementTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.SwitchStatementTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TryStatementTree;
import org.sonar.plugins.java.api.tree.WhileStatementTree;

@Rule(key="S134")
public class NestedIfStatementsCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private static final int DEFAULT_MAX = 3;
    @RuleProperty(description="Maximum allowed control flow statement nesting depth.", defaultValue="3")
    public int max = 3;
    private JavaFileScannerContext context;
    private Deque<Tree> nestingLevel;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.nestingLevel = new ArrayDeque<Tree>();
        this.scan((Tree)context.getTree());
    }

    public void visitIfStatement(IfStatementTree tree) {
        SyntaxToken ifKeyword = tree.ifKeyword();
        this.checkNesting((Tree)ifKeyword);
        this.nestingLevel.push((Tree)ifKeyword);
        this.visit(tree);
        this.nestingLevel.pop();
    }

    public void visitForStatement(ForStatementTree tree) {
        SyntaxToken forKeyword = tree.forKeyword();
        this.checkNesting((Tree)forKeyword);
        this.nestingLevel.push((Tree)forKeyword);
        super.visitForStatement(tree);
        this.nestingLevel.pop();
    }

    public void visitForEachStatement(ForEachStatement tree) {
        SyntaxToken forKeyword = tree.forKeyword();
        this.checkNesting((Tree)forKeyword);
        this.nestingLevel.push((Tree)forKeyword);
        super.visitForEachStatement(tree);
        this.nestingLevel.pop();
    }

    public void visitWhileStatement(WhileStatementTree tree) {
        SyntaxToken whileKeyword = tree.whileKeyword();
        this.checkNesting((Tree)whileKeyword);
        this.nestingLevel.push((Tree)whileKeyword);
        super.visitWhileStatement(tree);
        this.nestingLevel.pop();
    }

    public void visitDoWhileStatement(DoWhileStatementTree tree) {
        SyntaxToken doKeyword = tree.doKeyword();
        this.checkNesting((Tree)doKeyword);
        this.nestingLevel.push((Tree)doKeyword);
        super.visitDoWhileStatement(tree);
        this.nestingLevel.pop();
    }

    public void visitSwitchStatement(SwitchStatementTree tree) {
        SyntaxToken switchKeyword = tree.switchKeyword();
        this.checkNesting((Tree)switchKeyword);
        this.nestingLevel.push((Tree)switchKeyword);
        super.visitSwitchStatement(tree);
        this.nestingLevel.pop();
    }

    public void visitTryStatement(TryStatementTree tree) {
        SyntaxToken tryKeyword = tree.tryKeyword();
        this.checkNesting((Tree)tryKeyword);
        this.nestingLevel.push((Tree)tryKeyword);
        this.scan((Tree)tree.block());
        this.nestingLevel.pop();
        this.scan(tree.resources());
        this.scan(tree.catches());
        this.scan((Tree)tree.finallyBlock());
    }

    private void checkNesting(Tree tree) {
        int size = this.nestingLevel.size();
        if (size == this.max) {
            ArrayList<JavaFileScannerContext.Location> secondary = new ArrayList<JavaFileScannerContext.Location>(size);
            for (Tree element : this.nestingLevel) {
                secondary.add(new JavaFileScannerContext.Location("Nesting + 1", element));
            }
            this.context.reportIssue((JavaCheck)this, tree, "Refactor this code to not nest more than " + this.max + " if/for/while/switch/try statements.", secondary, null);
        }
    }

    private void visit(IfStatementTree tree) {
        this.scan((Tree)tree.condition());
        this.scan((Tree)tree.thenStatement());
        StatementTree elseStatementTree = tree.elseStatement();
        if (elseStatementTree != null && elseStatementTree.is(new Tree.Kind[]{Tree.Kind.IF_STATEMENT})) {
            this.visit((IfStatementTree)elseStatementTree);
        } else {
            this.scan((Tree)elseStatementTree);
        }
    }
}

