/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TryStatementTree;

@Rule(key="S1141")
public class NestedTryCatchCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private JavaFileScannerContext context;
    private Deque<Tree> nestingLevel = new ArrayDeque<Tree>();

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.nestingLevel.clear();
        this.scan((Tree)context.getTree());
    }

    public void visitTryStatement(TryStatementTree tree) {
        this.scan(tree.resources());
        if (!tree.catches().isEmpty()) {
            int size = this.nestingLevel.size();
            if (size > 0) {
                ArrayList<JavaFileScannerContext.Location> secondary = new ArrayList<JavaFileScannerContext.Location>(size);
                for (Tree element : this.nestingLevel) {
                    secondary.add(new JavaFileScannerContext.Location("Nesting + 1", element));
                }
                this.context.reportIssue((JavaCheck)this, (Tree)tree.tryKeyword(), "Extract this nested try block into a separate method.", secondary, null);
            }
            this.nestingLevel.push((Tree)tree.tryKeyword());
        }
        this.scan((Tree)tree.block());
        if (!tree.catches().isEmpty()) {
            this.nestingLevel.pop();
        }
        this.scan(tree.catches());
        this.scan((Tree)tree.finallyBlock());
    }
}

