/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.matcher.TypeCriteria;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S2133")
public class ObjectCreatedOnlyToCallGetClassCheck
extends AbstractMethodDetection {
    @Override
    protected List<MethodMatcher> getMethodInvocationMatchers() {
        return ImmutableList.of((Object)MethodMatcher.create().typeDefinition(TypeCriteria.subtypeOf((String)"java.lang.Object")).name("getClass"));
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        if (this.hasSemantic() && mit.methodSelect().is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            ExpressionTree expressionTree = ((MemberSelectExpressionTree)mit.methodSelect()).expression();
            if (expressionTree.is(new Tree.Kind[]{Tree.Kind.NEW_CLASS})) {
                this.reportIssue(expressionTree);
            } else if (expressionTree.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) && ObjectCreatedOnlyToCallGetClassCheck.variableUsedOnlyToGetClass((IdentifierTree)expressionTree)) {
                this.reportIssue(ObjectCreatedOnlyToCallGetClassCheck.getInitializer((IdentifierTree)expressionTree));
            }
        }
    }

    @CheckForNull
    private static ExpressionTree getInitializer(IdentifierTree tree) {
        VariableTree declaration;
        Symbol symbol = tree.symbol();
        if (symbol.isVariableSymbol() && (declaration = ((Symbol.VariableSymbol)symbol).declaration()) != null) {
            return declaration.initializer();
        }
        return null;
    }

    private static boolean variableUsedOnlyToGetClass(IdentifierTree tree) {
        if ("this".equals(tree.name()) || "super".equals(tree.name())) {
            return false;
        }
        Symbol symbol = tree.symbol();
        return symbol.usages().size() == 1 && ObjectCreatedOnlyToCallGetClassCheck.hasBeenInitialized(tree);
    }

    private static boolean hasBeenInitialized(IdentifierTree tree) {
        ExpressionTree initializer = ObjectCreatedOnlyToCallGetClassCheck.getInitializer(tree);
        return initializer != null && initializer.is(new Tree.Kind[]{Tree.Kind.NEW_CLASS});
    }

    private void reportIssue(@Nullable ExpressionTree expressionTree) {
        if (expressionTree != null) {
            this.reportIssue((Tree)expressionTree, "Remove this object instantiation and use \"" + ObjectCreatedOnlyToCallGetClassCheck.getTypeName(expressionTree) + ".class\" instead.");
        }
    }

    private static String getTypeName(ExpressionTree tree) {
        Type type = tree.symbolType();
        String name = ObjectCreatedOnlyToCallGetClassCheck.getTypeName(type);
        if (name.isEmpty()) {
            name = ObjectCreatedOnlyToCallGetClassCheck.getAnonymousClassTypeName(type.symbol());
        }
        return name;
    }

    private static String getAnonymousClassTypeName(Symbol.TypeSymbol symbol) {
        if (symbol.interfaces().isEmpty()) {
            return ObjectCreatedOnlyToCallGetClassCheck.getTypeName(symbol.superClass());
        }
        return ObjectCreatedOnlyToCallGetClassCheck.getTypeName((Type)symbol.interfaces().get(0));
    }

    private static String getTypeName(Type type) {
        return type.symbol().name();
    }
}

