/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.serialization;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2063")
public class SerializableComparatorCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.CLASS);
    }

    public void visitNode(Tree tree) {
        if (this.hasSemantic()) {
            ClassTree classTree = (ClassTree)tree;
            Symbol.TypeSymbol symbol = classTree.symbol();
            Type type = symbol.type();
            IdentifierTree simpleName = classTree.simpleName();
            if (simpleName != null && type.isSubtypeOf("java.util.Comparator") && !type.isSubtypeOf("java.io.Serializable") && !symbol.isAbstract()) {
                this.reportIssue((Tree)simpleName, "Make this class \"Serializable\".");
            }
        }
    }
}

