/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.unused;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.BooleanUtils;
import org.sonar.check.Rule;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.matcher.MethodMatcherCollection;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.java.model.declaration.MethodTreeImpl;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.NewArrayTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1172")
public class UnusedMethodParameterCheck
extends IssuableSubscriptionVisitor {
    private static final String AUTHORIZED_ANNOTATION = "javax.enterprise.event.Observes";
    private static final String SUPPRESS_WARNINGS_ANNOTATION = "java.lang.SuppressWarnings";
    private static final Collection<String> EXCLUDED_WARNINGS_SUPPRESSIONS = ImmutableList.of((Object)"\"rawtypes\"", (Object)"\"unchecked\"");
    private static final MethodMatcherCollection SERIALIZABLE_METHODS = MethodMatcherCollection.create((MethodMatcher[])new MethodMatcher[]{MethodMatcher.create().name("writeObject").addParameter("java.io.ObjectOutputStream"), MethodMatcher.create().name("readObject").addParameter("java.io.ObjectInputStream")});

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.METHOD, (Object)Tree.Kind.CONSTRUCTOR);
    }

    public void visitNode(Tree tree) {
        MethodTree methodTree = (MethodTree)tree;
        if (this.hasSemantic() && methodTree.block() != null && !UnusedMethodParameterCheck.isExcluded(methodTree)) {
            ArrayList unused = Lists.newArrayList();
            for (Object var : methodTree.parameters()) {
                Symbol symbol = var.symbol();
                if (!symbol.usages().isEmpty() || symbol.metadata().isAnnotatedWith(AUTHORIZED_ANNOTATION)) continue;
                unused.add(var.simpleName());
            }
            if (!unused.isEmpty()) {
                ArrayList<JavaFileScannerContext.Location> locations = new ArrayList<JavaFileScannerContext.Location>();
                for (IdentifierTree identifier : unused.subList(1, unused.size())) {
                    locations.add(new JavaFileScannerContext.Location("Remove this unused method parameter " + identifier.name() + "\".", (Tree)identifier));
                }
                IdentifierTree firstUnused = (IdentifierTree)unused.get(0);
                this.reportIssue((Tree)firstUnused, "Remove this unused method parameter \"" + firstUnused.name() + "\".", locations, null);
            }
        }
    }

    private static boolean isExcluded(MethodTree tree) {
        return ((MethodTreeImpl)tree).isMainMethod() || UnusedMethodParameterCheck.isAnnotated(tree) || UnusedMethodParameterCheck.isOverriding(tree) || UnusedMethodParameterCheck.isSerializableMethod(tree) || UnusedMethodParameterCheck.isDesignedForExtension(tree);
    }

    private static boolean isAnnotated(MethodTree tree) {
        return tree.modifiers().annotations().stream().anyMatch(annotation -> !UnusedMethodParameterCheck.isExcludedLiteral((Tree)annotation));
    }

    private static boolean isExcludedLiteral(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.ANNOTATION})) {
            AnnotationTree annotationTree = (AnnotationTree)tree;
            return annotationTree.annotationType().symbolType().is(SUPPRESS_WARNINGS_ANNOTATION) && annotationTree.arguments().stream().allMatch(UnusedMethodParameterCheck::isExcludedLiteral);
        }
        if (tree.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL})) {
            return EXCLUDED_WARNINGS_SUPPRESSIONS.contains(((LiteralTree)tree).value());
        }
        if (tree.is(new Tree.Kind[]{Tree.Kind.NEW_ARRAY})) {
            return ((NewArrayTree)tree).initializers().stream().allMatch(UnusedMethodParameterCheck::isExcludedLiteral);
        }
        return false;
    }

    private static boolean isDesignedForExtension(MethodTree tree) {
        ModifiersTree modifiers = tree.modifiers();
        return ModifiersUtils.hasModifier((ModifiersTree)modifiers, (Modifier)Modifier.DEFAULT) || !ModifiersUtils.hasModifier((ModifiersTree)modifiers, (Modifier)Modifier.PRIVATE) && UnusedMethodParameterCheck.isEmptyOrThrowStatement(tree.block());
    }

    private static boolean isEmptyOrThrowStatement(BlockTree block) {
        return block.body().isEmpty() || block.body().size() == 1 && ((StatementTree)block.body().get(0)).is(new Tree.Kind[]{Tree.Kind.THROW_STATEMENT});
    }

    private static boolean isSerializableMethod(MethodTree methodTree) {
        return ModifiersUtils.hasModifier((ModifiersTree)methodTree.modifiers(), (Modifier)Modifier.PRIVATE) && SERIALIZABLE_METHODS.anyMatch(methodTree);
    }

    private static boolean isOverriding(MethodTree tree) {
        return !BooleanUtils.isFalse((Boolean)((MethodTreeImpl)tree).isOverriding());
    }
}

