/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.xml.maven;

import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.checks.xml.maven.helpers.MavenDependencyCollector;
import org.sonar.java.checks.xml.maven.helpers.MavenDependencyMatcher;
import org.sonar.java.xml.maven.PomCheck;
import org.sonar.java.xml.maven.PomCheckContext;
import org.sonar.maven.model.LocatedTree;
import org.sonar.maven.model.maven2.Dependency;
import org.sonar.squidbridge.annotations.RuleTemplate;

@Rule(key="S3417")
@RuleTemplate
public class DisallowedDependenciesCheck
implements PomCheck {
    public static final String KEY = "S3417";
    @RuleProperty(key="dependencyName", description="Pattern describing forbidden dependencies group and artifact ids. E.G. '``*:.*log4j``' or '``x.y:*``'")
    public String dependencyName = "";
    @RuleProperty(key="version", description="Dependency version pattern or dash-delimited range. Leave blank for all versions. E.G. '``1.3.*``', '``1.0-3.1``', '``1.0-*``' or '``*-3.1``'")
    public String version = "";
    private MavenDependencyMatcher matcher = null;

    public void scanFile(PomCheckContext context) {
        for (Dependency dependency : new MavenDependencyCollector(context.getMavenProject()).allDependencies()) {
            if (!this.getMatcher().matches(dependency)) continue;
            context.reportIssue((PomCheck)this, (LocatedTree)dependency, "Remove this forbidden dependency.");
        }
    }

    private MavenDependencyMatcher getMatcher() {
        if (this.matcher == null) {
            try {
                this.matcher = new MavenDependencyMatcher(this.dependencyName, this.version);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("[S3417] Unable to build matchers from provided dependency name: " + this.dependencyName, e);
            }
        }
        return this.matcher;
    }
}

