/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.resources;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.sonar.api.batch.BatchSide;
import org.sonar.api.ce.ComputeEngineSide;
import org.sonar.api.internal.google.common.base.Preconditions;
import org.sonar.api.internal.google.common.base.Predicate;
import org.sonar.api.internal.google.common.collect.ArrayListMultimap;
import org.sonar.api.internal.google.common.collect.Collections2;
import org.sonar.api.internal.google.common.collect.ImmutableList;
import org.sonar.api.internal.google.common.collect.ImmutableListMultimap;
import org.sonar.api.internal.google.common.collect.ListMultimap;
import org.sonar.api.resources.ResourceType;
import org.sonar.api.server.ServerSide;

@BatchSide
@ServerSide
@ComputeEngineSide
public class ResourceTypeTree {
    private final List<ResourceType> types;
    private final ListMultimap<String, String> relations;
    private final ResourceType root;

    private ResourceTypeTree(Builder builder) {
        this.types = ImmutableList.copyOf(builder.types);
        this.relations = ImmutableListMultimap.copyOf(builder.relations);
        this.root = builder.root;
    }

    public List<ResourceType> getTypes() {
        return this.types;
    }

    public List<String> getChildren(String qualifier) {
        return this.relations.get(qualifier);
    }

    public ResourceType getRootType() {
        return this.root;
    }

    public List<String> getLeaves() {
        return ImmutableList.copyOf(Collections2.filter(this.relations.values(), new Predicate<String>(){

            @Override
            public boolean apply(String qualifier) {
                return ResourceTypeTree.this.relations.get(qualifier).isEmpty();
            }
        }));
    }

    public String toString() {
        return this.root.getQualifier();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<ResourceType> types = new ArrayList<ResourceType>();
        private ListMultimap<String, String> relations = ArrayListMultimap.create();
        private ResourceType root;

        private Builder() {
        }

        public Builder addType(ResourceType type) {
            Preconditions.checkNotNull(type);
            Preconditions.checkArgument(!this.types.contains(type), String.format("%s is already registered", type.getQualifier()));
            this.types.add(type);
            return this;
        }

        public Builder addRelations(String parentQualifier, String ... childrenQualifiers) {
            Preconditions.checkNotNull(parentQualifier);
            Preconditions.checkNotNull(childrenQualifiers);
            Preconditions.checkArgument(childrenQualifiers.length > 0, "childrenQualifiers can't be empty");
            this.relations.putAll(parentQualifier, Arrays.asList(childrenQualifiers));
            return this;
        }

        public ResourceTypeTree build() {
            Collection children = this.relations.values();
            for (ResourceType type : this.types) {
                if (children.contains(type.getQualifier())) continue;
                this.root = type;
                break;
            }
            return new ResourceTypeTree(this);
        }
    }
}

