/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.resources;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.sonar.api.ce.ComputeEngineSide;
import org.sonar.api.internal.google.common.annotations.Beta;
import org.sonar.api.internal.google.common.base.Function;
import org.sonar.api.internal.google.common.base.Objects;
import org.sonar.api.internal.google.common.base.Preconditions;
import org.sonar.api.internal.google.common.base.Predicate;
import org.sonar.api.internal.google.common.collect.Collections2;
import org.sonar.api.internal.google.common.collect.ImmutableList;
import org.sonar.api.internal.google.common.collect.ImmutableMap;
import org.sonar.api.internal.google.common.collect.ImmutableSet;
import org.sonar.api.internal.google.common.collect.Lists;
import org.sonar.api.internal.google.common.collect.Maps;
import org.sonar.api.internal.google.common.collect.Sets;
import org.sonar.api.resources.ResourceType;
import org.sonar.api.resources.ResourceTypeTree;
import org.sonar.api.server.ServerSide;

@ServerSide
@ComputeEngineSide
@Beta
public class ResourceTypes {
    public static final Predicate<ResourceType> AVAILABLE_FOR_FILTERS = new Predicate<ResourceType>(){

        @Override
        public boolean apply(@Nullable ResourceType input) {
            return input != null && input.getBooleanProperty("supportsMeasureFilters");
        }
    };
    private final Map<String, ResourceTypeTree> treeByQualifier;
    private final Map<String, ResourceType> typeByQualifier;
    private final Collection<ResourceType> orderedTypes;
    private final Collection<ResourceType> rootTypes;

    public ResourceTypes() {
        this(new ResourceTypeTree[0]);
    }

    public ResourceTypes(ResourceTypeTree[] trees) {
        Preconditions.checkNotNull(trees);
        HashMap<String, ResourceTypeTree> treeMap = Maps.newHashMap();
        LinkedHashMap<String, ResourceType> typeMap = Maps.newLinkedHashMap();
        HashSet<ResourceType> rootsSet = Sets.newHashSet();
        for (ResourceTypeTree tree : trees) {
            rootsSet.add(tree.getRootType());
            for (ResourceType type : tree.getTypes()) {
                if (treeMap.containsKey(type.getQualifier())) {
                    throw new IllegalStateException("Qualifier " + type.getQualifier() + " is defined in several trees");
                }
                treeMap.put(type.getQualifier(), tree);
                typeMap.put(type.getQualifier(), type);
            }
        }
        this.treeByQualifier = ImmutableMap.copyOf(treeMap);
        this.typeByQualifier = ImmutableMap.copyOf(typeMap);
        this.rootTypes = ImmutableList.copyOf(rootsSet);
        ArrayList<ResourceType> mutableOrderedTypes = new ArrayList<ResourceType>();
        ResourceType view = null;
        ResourceType subView = null;
        for (ResourceType resourceType : this.typeByQualifier.values()) {
            if ("VW".equals(resourceType.getQualifier())) {
                view = resourceType;
                continue;
            }
            if ("SVW".equals(resourceType.getQualifier())) {
                subView = resourceType;
                continue;
            }
            mutableOrderedTypes.add(resourceType);
        }
        if (subView != null) {
            mutableOrderedTypes.add(0, subView);
        }
        if (view != null) {
            mutableOrderedTypes.add(0, view);
        }
        this.orderedTypes = ImmutableSet.copyOf(mutableOrderedTypes);
    }

    public ResourceType get(String qualifier) {
        ResourceType type = this.typeByQualifier.get(qualifier);
        return type != null ? type : ResourceType.builder(qualifier).build();
    }

    public Collection<ResourceType> getAll() {
        return this.typeByQualifier.values();
    }

    public Collection<ResourceType> getAllOrdered() {
        return this.orderedTypes;
    }

    public Collection<ResourceType> getRoots() {
        return this.rootTypes;
    }

    public Collection<ResourceType> getAll(Predicate<ResourceType> predicate) {
        return Collections2.filter(this.typeByQualifier.values(), predicate);
    }

    public Collection<ResourceType> getAllWithPropertyKey(String propertyKey) {
        return Collections2.filter(this.typeByQualifier.values(), new PropertyKeyPredicate(propertyKey));
    }

    public Collection<ResourceType> getAllWithPropertyValue(String propertyKey, String propertyValue) {
        return Collections2.filter(this.typeByQualifier.values(), new StringPropertyValuePredicate(propertyValue, propertyKey));
    }

    public Collection<ResourceType> getAllWithPropertyValue(String propertyKey, boolean propertyValue) {
        return Collections2.filter(this.typeByQualifier.values(), new BooleanPropertyValuePredicate(propertyKey, propertyValue));
    }

    public List<String> getChildrenQualifiers(String qualifier) {
        ResourceTypeTree tree = this.getTree(qualifier);
        if (tree != null) {
            return tree.getChildren(qualifier);
        }
        return Collections.emptyList();
    }

    public List<ResourceType> getChildren(String qualifier) {
        return Lists.transform(this.getChildrenQualifiers(qualifier), new Function<String, ResourceType>(){

            @Override
            public ResourceType apply(String s) {
                return (ResourceType)ResourceTypes.this.typeByQualifier.get(s);
            }
        });
    }

    public List<String> getLeavesQualifiers(String qualifier) {
        ResourceTypeTree tree = this.getTree(qualifier);
        if (tree != null) {
            return tree.getLeaves();
        }
        return Collections.emptyList();
    }

    public ResourceTypeTree getTree(String qualifier) {
        return this.treeByQualifier.get(qualifier);
    }

    public ResourceType getRoot(String qualifier) {
        return this.getTree(qualifier).getRootType();
    }

    private static class BooleanPropertyValuePredicate
    implements Predicate<ResourceType> {
        private final String propertyKey;
        private final boolean propertyValue;

        public BooleanPropertyValuePredicate(String propertyKey, boolean propertyValue) {
            this.propertyKey = propertyKey;
            this.propertyValue = propertyValue;
        }

        @Override
        public boolean apply(@Nullable ResourceType input) {
            return input != null && input.getBooleanProperty(this.propertyKey) == this.propertyValue;
        }
    }

    private static class StringPropertyValuePredicate
    implements Predicate<ResourceType> {
        private final String propertyValue;
        private final String propertyKey;

        public StringPropertyValuePredicate(String propertyValue, String propertyKey) {
            this.propertyValue = propertyValue;
            this.propertyKey = propertyKey;
        }

        @Override
        public boolean apply(@Nullable ResourceType input) {
            return input != null && Objects.equal(this.propertyValue, input.getStringProperty(this.propertyKey));
        }
    }

    private static class PropertyKeyPredicate
    implements Predicate<ResourceType> {
        private final String propertyKey;

        public PropertyKeyPredicate(String propertyKey) {
            this.propertyKey = propertyKey;
        }

        @Override
        public boolean apply(@Nullable ResourceType input) {
            return input != null && input.hasProperty(this.propertyKey);
        }
    }
}

