/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.rules;

import java.util.Arrays;
import java.util.Set;
import javax.annotation.Nonnull;
import org.sonar.api.internal.google.common.base.Function;
import org.sonar.api.internal.google.common.collect.FluentIterable;

public enum RuleType {
    CODE_SMELL(1),
    BUG(2),
    VULNERABILITY(3);

    private static final Set<String> ALL_NAMES;
    private final int dbConstant;

    private RuleType(int dbConstant) {
        this.dbConstant = dbConstant;
    }

    public int getDbConstant() {
        return this.dbConstant;
    }

    public static Set<String> names() {
        return ALL_NAMES;
    }

    public static RuleType valueOf(int dbConstant) {
        for (RuleType type : RuleType.values()) {
            if (type.getDbConstant() != dbConstant) continue;
            return type;
        }
        throw new IllegalArgumentException(String.format("Unsupported type value : %d", dbConstant));
    }

    static {
        ALL_NAMES = FluentIterable.from(Arrays.asList(RuleType.values())).transform(ToName.INSTANCE).toSet();
    }

    private static enum ToName implements Function<RuleType, String>
    {
        INSTANCE;


        @Override
        public String apply(@Nonnull RuleType input) {
            return input.name();
        }
    }
}

