/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.duplications.index;

public final class DataUtils {
    public static int binarySearch(Sortable data) {
        int value = data.size();
        int lower = 0;
        int upper = data.size();
        while (lower < upper) {
            int mid = lower + upper >> 1;
            if (data.isLess(mid, value)) {
                lower = mid + 1;
                continue;
            }
            upper = mid;
        }
        return lower;
    }

    public static void sort(Sortable data) {
        DataUtils.quickSort(data, 0, data.size() - 1);
    }

    private static void bubbleSort(Sortable data, int left, int right) {
        for (int i = right; i > left; --i) {
            for (int j = left; j < i; ++j) {
                if (!data.isLess(j + 1, j)) continue;
                data.swap(j, j + 1);
            }
        }
    }

    private static int partition(Sortable data, int i, int j) {
        int pivot = i + (j - i) / 2;
        while (i <= j) {
            while (data.isLess(i, pivot)) {
                ++i;
            }
            while (data.isLess(pivot, j)) {
                --j;
            }
            if (i > j) continue;
            data.swap(i, j);
            if (i == pivot) {
                pivot = j;
            } else if (j == pivot) {
                pivot = i;
            }
            ++i;
            --j;
        }
        return i;
    }

    private static void quickSort(Sortable data, int low, int high) {
        if (high - low < 5) {
            DataUtils.bubbleSort(data, low, high);
            return;
        }
        int i = DataUtils.partition(data, low, high);
        if (low < i - 1) {
            DataUtils.quickSort(data, low, i - 1);
        }
        if (i < high) {
            DataUtils.quickSort(data, i, high);
        }
    }

    private DataUtils() {
    }

    public static interface Sortable {
        public int size();

        public void swap(int var1, int var2);

        public boolean isLess(int var1, int var2);
    }
}

