/*
 * Decompiled with CFR 0.152.
 */
package com.sonar.sslr.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.io.Closeables;
import com.sonar.sslr.api.GenericTokenType;
import com.sonar.sslr.api.Preprocessor;
import com.sonar.sslr.api.PreprocessorAction;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.api.Trivia;
import com.sonar.sslr.impl.LexerException;
import java.io.Closeable;
import java.io.File;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.sonar.sslr.channel.Channel;
import org.sonar.sslr.channel.ChannelDispatcher;
import org.sonar.sslr.channel.CodeReader;
import org.sonar.sslr.channel.CodeReaderConfiguration;

public class Lexer {
    private final Charset charset;
    private final CodeReaderConfiguration configuration;
    private final ChannelDispatcher<Lexer> channelDispatcher;
    private final Preprocessor[] preprocessors;
    private URI uri;
    private final List<Trivia> trivia = new LinkedList<Trivia>();
    private List<Token> tokens = new ArrayList<Token>();

    private Lexer(Builder builder) {
        this.charset = builder.charset;
        this.preprocessors = builder.preprocessors.toArray(new Preprocessor[builder.preprocessors.size()]);
        this.configuration = builder.configuration;
        this.channelDispatcher = builder.getChannelDispatcher();
        try {
            this.uri = new URI("tests://unittest");
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
    }

    public List<Token> lex(File file) {
        Preconditions.checkNotNull((Object)file, (Object)"file cannot be null");
        Preconditions.checkArgument((boolean)file.isFile(), (String)"file \"%s\" must be a file", (Object[])new Object[]{file.getAbsolutePath()});
        try {
            return this.lex(file.toURI().toURL());
        }
        catch (MalformedURLException e) {
            throw new LexerException("Unable to lex file: " + file.getAbsolutePath(), e);
        }
    }

    public List<Token> lex(URL url) {
        List<Token> list;
        Preconditions.checkNotNull((Object)url, (Object)"url cannot be null");
        InputStreamReader reader = null;
        try {
            this.uri = url.toURI();
            reader = new InputStreamReader(url.openStream(), this.charset);
            list = this.lex(reader);
        }
        catch (Exception e) {
            try {
                throw new LexerException("Unable to lex url: " + this.getURI(), e);
            }
            catch (Throwable throwable) {
                Closeables.closeQuietly(reader);
                throw throwable;
            }
        }
        Closeables.closeQuietly((Closeable)reader);
        return list;
    }

    @VisibleForTesting
    public List<Token> lex(String sourceCode) {
        Preconditions.checkNotNull((Object)sourceCode, (Object)"sourceCode cannot be null");
        try {
            return this.lex(new StringReader(sourceCode));
        }
        catch (Exception e) {
            throw new LexerException("Unable to lex string source code \"" + sourceCode + "\"", e);
        }
    }

    private List<Token> lex(Reader reader) {
        this.tokens = new ArrayList<Token>();
        this.initPreprocessors();
        CodeReader code = new CodeReader(reader, this.configuration);
        try {
            this.channelDispatcher.consume(code, this);
            this.addToken(Token.builder().setType(GenericTokenType.EOF).setValueAndOriginalValue("EOF").setURI(this.uri).setLine(code.getLinePosition()).setColumn(code.getColumnPosition()).build());
            this.preprocess();
            return this.getTokens();
        }
        catch (Exception e) {
            throw new LexerException("Unable to lex source code at line : " + code.getLinePosition() + " and column : " + code.getColumnPosition() + " in file : " + this.uri, e);
        }
    }

    private void preprocess() {
        for (Preprocessor preprocessor : this.preprocessors) {
            this.preprocess(preprocessor);
        }
    }

    private void preprocess(Preprocessor preprocessor) {
        List<Token> remainingTokens = Collections.unmodifiableList(new ArrayList<Token>(this.tokens));
        this.tokens.clear();
        int i = 0;
        while (i < remainingTokens.size()) {
            PreprocessorAction action = preprocessor.process(remainingTokens.subList(i, remainingTokens.size()));
            Preconditions.checkNotNull((Object)action, (Object)"A preprocessor cannot return a null PreprocessorAction");
            this.addTrivia(action.getTriviaToInject());
            for (int j = 0; j < action.getNumberOfConsumedTokens(); ++j) {
                Token removedToken = remainingTokens.get(i);
                ++i;
                this.addTrivia(removedToken.getTrivia());
            }
            for (Token tokenToInject : action.getTokensToInject()) {
                this.addToken(tokenToInject);
            }
            if (action.getNumberOfConsumedTokens() != 0) continue;
            Token removedToken = remainingTokens.get(i);
            ++i;
            this.addTrivia(removedToken.getTrivia());
            this.addToken(removedToken);
        }
    }

    private void initPreprocessors() {
        for (Preprocessor preprocessor : this.preprocessors) {
            preprocessor.init();
        }
    }

    public void addTrivia(Trivia ... trivia) {
        this.addTrivia(Arrays.asList(trivia));
    }

    public void addTrivia(List<Trivia> trivia) {
        Preconditions.checkNotNull(trivia, (Object)"trivia cannot be null");
        this.trivia.addAll(trivia);
    }

    public void addToken(Token ... tokens) {
        Token firstTokenWithTrivia;
        Preconditions.checkArgument((tokens.length > 0 ? 1 : 0) != 0, (Object)"at least one token must be given");
        Token firstToken = tokens[0];
        if (this.trivia.isEmpty() && !firstToken.hasTrivia()) {
            firstTokenWithTrivia = firstToken;
        } else {
            firstTokenWithTrivia = Token.builder(firstToken).setTrivia(this.trivia).build();
            this.trivia.clear();
        }
        this.tokens.add(firstTokenWithTrivia);
        if (tokens.length > 1) {
            this.tokens.addAll(Arrays.asList(tokens).subList(1, tokens.length));
        }
    }

    public List<Token> getTokens() {
        return Collections.unmodifiableList(this.tokens);
    }

    public URI getURI() {
        return this.uri;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Charset charset = Charset.defaultCharset();
        private final List<Preprocessor> preprocessors = new ArrayList<Preprocessor>();
        private final CodeReaderConfiguration configuration = new CodeReaderConfiguration();
        private final List<Channel<Lexer>> channels = new ArrayList<Channel<Lexer>>();
        private boolean failIfNoChannelToConsumeOneCharacter = false;

        private Builder() {
        }

        public Lexer build() {
            return new Lexer(this);
        }

        public Builder withCharset(Charset charset) {
            this.charset = charset;
            return this;
        }

        public Builder withPreprocessor(Preprocessor preprocessor) {
            this.preprocessors.add(preprocessor);
            return this;
        }

        public Builder withChannel(Channel<Lexer> channel) {
            this.channels.add(channel);
            return this;
        }

        public Builder withFailIfNoChannelToConsumeOneCharacter(boolean failIfNoChannelToConsumeOneCharacter) {
            this.failIfNoChannelToConsumeOneCharacter = failIfNoChannelToConsumeOneCharacter;
            return this;
        }

        private ChannelDispatcher<Lexer> getChannelDispatcher() {
            ChannelDispatcher.Builder builder = ChannelDispatcher.builder().addChannels(this.channels.toArray(new Channel[this.channels.size()]));
            if (this.failIfNoChannelToConsumeOneCharacter) {
                builder.failIfNoChannelToConsumeOneCharacter();
            }
            return builder.build();
        }
    }
}

