/*
 * Decompiled with CFR 0.152.
 */
package com.sonar.sslr.impl.ast;

import com.google.common.base.Throwables;
import com.sonar.sslr.api.AstNode;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;

public final class AstXmlPrinter {
    private final AstNode rootNode;
    private final Writer writer;

    private AstXmlPrinter(AstNode rootNode, Writer writer) {
        this.rootNode = rootNode;
        this.writer = writer;
    }

    public static String print(AstNode rootNode) {
        StringWriter writer = new StringWriter();
        AstXmlPrinter.print(rootNode, writer);
        return writer.toString();
    }

    public static void print(AstNode rootNode, Writer writer) {
        AstXmlPrinter printer = new AstXmlPrinter(rootNode, writer);
        printer.print();
    }

    private void print() {
        try {
            this.printNode(0, this.rootNode);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private void printNode(int level, AstNode node) throws IOException {
        if (level != 0) {
            this.writer.append("\n");
        }
        this.appendSpaces(level);
        if (node.hasChildren()) {
            this.writer.append("<");
            this.appendNodecontent(node);
            this.writer.append(">");
            this.toXmlChildren(level, node);
            this.appendCarriageReturnAndSpaces(level);
            this.writer.append("</").append(node.getName()).append(">");
        } else {
            this.writer.append("<");
            this.appendNodecontent(node);
            this.writer.append("/>");
        }
    }

    private void appendNodecontent(AstNode node) throws IOException {
        this.writer.append(node.getName());
        if (node.getTokenValue() != null) {
            this.writer.append(" tokenValue=\"" + node.getTokenValue() + "\"");
        }
        if (node.hasToken()) {
            this.writer.append(" tokenLine=\"" + node.getTokenLine() + "\" tokenColumn=\"" + node.getToken().getColumn() + "\"");
        }
    }

    private void toXmlChildren(int level, AstNode node) throws IOException {
        for (AstNode child : node.getChildren()) {
            this.printNode(level + 1, child);
        }
    }

    private void appendCarriageReturnAndSpaces(int level) throws IOException {
        this.writer.append("\n");
        this.appendSpaces(level);
    }

    private void appendSpaces(int level) throws IOException {
        for (int i = 0; i < level; ++i) {
            this.writer.append("  ");
        }
    }
}

