/*
 * Decompiled with CFR 0.152.
 */
package com.sonar.sslr.impl.typed;

import com.google.common.base.Throwables;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ReflectionUtils {
    private ReflectionUtils() {
    }

    public static Object invokeMethod(Method method, Object object, Object ... args) {
        try {
            return method.invoke(object, args);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static Field getField(Class<?> clazz, String fieldName) {
        try {
            Field field = clazz.getDeclaredField(fieldName);
            field.setAccessible(true);
            return field;
        }
        catch (NoSuchFieldException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static void setField(Field field, Object instance, Object value) {
        try {
            field.set(instance, value);
        }
        catch (IllegalAccessException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

