/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library.model.license;

import java.util.Collection;
import java.util.Optional;
import org.spdx.library.InvalidSPDXAnalysisException;
import org.spdx.library.ModelCopyManager;
import org.spdx.library.model.ModelObject;
import org.spdx.library.model.license.LicenseException;
import org.spdx.licenseTemplate.LicenseTemplateRuleException;
import org.spdx.licenseTemplate.SpdxLicenseTemplateHelper;
import org.spdx.storage.IModelStore;

public class ListedLicenseException
extends LicenseException {
    public ListedLicenseException(IModelStore modelStore, String documentUri, String id, ModelCopyManager copyManager, boolean create) throws InvalidSPDXAnalysisException {
        super(modelStore, documentUri, id, copyManager, create);
    }

    public ListedLicenseException(String id, String name, String text, Collection<String> seeAlso, String comment) throws InvalidSPDXAnalysisException {
        super(id, name, text, seeAlso, comment);
    }

    public ListedLicenseException(String id, String name, String text, String template, Collection<String> seeAlso, String comment) throws InvalidSPDXAnalysisException {
        super(id, name, text, template, seeAlso, comment);
    }

    public ListedLicenseException(String id, String name, String text) throws InvalidSPDXAnalysisException {
        super(id, name, text);
    }

    @Override
    public String getType() {
        return "ListedLicenseException";
    }

    public void setExceptionTextHtml(String exceptionTextHtml) throws InvalidSPDXAnalysisException {
        this.setPropertyValue("exceptionTextHtml", exceptionTextHtml);
    }

    public String getExceptionTextHtml() throws InvalidSPDXAnalysisException {
        Optional<String> exceptionTextHtml = this.getStringPropertyValue("exceptionTextHtml");
        if (exceptionTextHtml.isPresent()) {
            return exceptionTextHtml.get();
        }
        Optional<String> templateText = this.getStringPropertyValue("licenseExceptionTemplate");
        if (templateText.isPresent()) {
            try {
                return SpdxLicenseTemplateHelper.templateTextToHtml(templateText.get());
            }
            catch (LicenseTemplateRuleException ex) {
                throw new InvalidSPDXAnalysisException("Invalid license rule found in exception text for exception " + this.getName() + ":" + ex.getMessage());
            }
        }
        Optional<String> exceptionText = this.getStringPropertyValue("licenseExceptionText");
        if (exceptionText.isPresent()) {
            return SpdxLicenseTemplateHelper.formatEscapeHTML(exceptionText.get());
        }
        return "";
    }

    @Override
    public boolean equivalent(ModelObject compare, boolean ignoreRelatedElements) throws InvalidSPDXAnalysisException {
        if (compare instanceof ListedLicenseException) {
            return this.getId().equals(((ListedLicenseException)compare).getId());
        }
        return super.equivalent(compare, ignoreRelatedElements);
    }
}

