/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.compiler;

import java.io.File;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.AnnotationConstantExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.spockframework.compiler.AbstractSpecVisitor;
import org.spockframework.compiler.AstNodeCache;
import org.spockframework.compiler.model.Block;
import org.spockframework.compiler.model.CleanupBlock;
import org.spockframework.compiler.model.ExpectBlock;
import org.spockframework.compiler.model.FeatureMethod;
import org.spockframework.compiler.model.Field;
import org.spockframework.compiler.model.Method;
import org.spockframework.compiler.model.SetupBlock;
import org.spockframework.compiler.model.Spec;
import org.spockframework.compiler.model.ThenBlock;
import org.spockframework.compiler.model.WhenBlock;
import org.spockframework.compiler.model.WhereBlock;
import org.spockframework.runtime.model.BlockKind;

public class SpecAnnotator
extends AbstractSpecVisitor {
    private final AstNodeCache nodeCache;
    private ListExpression blockAnnElems;

    public SpecAnnotator(AstNodeCache nodeCache) {
        this.nodeCache = nodeCache;
    }

    @Override
    public void visitSpec(Spec spec) throws Exception {
        this.addSpecMetadata(spec);
    }

    private void addSpecMetadata(Spec spec) {
        AnnotationNode ann = new AnnotationNode(this.nodeCache.SpecMetadata);
        String pathname = ((ClassNode)spec.getAst()).getModule().getContext().getName();
        String filename = new File(pathname).getName();
        ann.setMember("filename", (Expression)new ConstantExpression((Object)filename));
        ann.setMember("line", (Expression)new ConstantExpression((Object)((ClassNode)spec.getAst()).getLineNumber()));
        ((ClassNode)spec.getAst()).addAnnotation(ann);
    }

    @Override
    public void visitField(Field field) throws Exception {
        this.addFieldMetadata(field);
    }

    private void addFieldMetadata(Field field) {
        AnnotationNode ann = new AnnotationNode(this.nodeCache.FieldMetadata);
        ann.setMember("name", (Expression)new ConstantExpression((Object)field.getName()));
        ann.setMember("ordinal", (Expression)new ConstantExpression((Object)field.getOrdinal()));
        ann.setMember("line", (Expression)new ConstantExpression((Object)((FieldNode)field.getAst()).getLineNumber()));
        ann.setMember("initializer", (Expression)new ConstantExpression((Object)field.hasInitialExpression()));
        ((FieldNode)field.getAst()).addAnnotation(ann);
    }

    @Override
    public void visitMethod(Method method) throws Exception {
        if (method instanceof FeatureMethod) {
            this.addFeatureMetadata((FeatureMethod)method);
        }
    }

    private void addFeatureMetadata(FeatureMethod feature) {
        AnnotationNode ann = new AnnotationNode(this.nodeCache.FeatureMetadata);
        ann.setMember("name", (Expression)new ConstantExpression((Object)feature.getName()));
        ann.setMember("ordinal", (Expression)new ConstantExpression((Object)feature.getOrdinal()));
        ann.setMember("line", (Expression)new ConstantExpression((Object)((MethodNode)feature.getAst()).getLineNumber()));
        this.blockAnnElems = new ListExpression();
        ann.setMember("blocks", (Expression)this.blockAnnElems);
        ListExpression paramNames = new ListExpression();
        for (Parameter param : ((MethodNode)feature.getAst()).getParameters()) {
            paramNames.addExpression((Expression)new ConstantExpression((Object)param.getName()));
        }
        ann.setMember("parameterNames", (Expression)paramNames);
        ((MethodNode)feature.getAst()).addAnnotation(ann);
    }

    private void addBlockMetadata(Block block, BlockKind kind) {
        AnnotationNode blockAnn = new AnnotationNode(this.nodeCache.BlockMetadata);
        blockAnn.setMember("kind", (Expression)new PropertyExpression((Expression)new ClassExpression(this.nodeCache.BlockKind), kind.name()));
        ListExpression textExprs = new ListExpression();
        for (String text : block.getDescriptions()) {
            textExprs.addExpression((Expression)new ConstantExpression((Object)text));
        }
        blockAnn.setMember("texts", (Expression)textExprs);
        this.blockAnnElems.addExpression((Expression)new AnnotationConstantExpression(blockAnn));
    }

    @Override
    public void visitSetupBlock(SetupBlock block) throws Exception {
        this.addBlockMetadata(block, BlockKind.SETUP);
    }

    @Override
    public void visitExpectBlock(ExpectBlock block) throws Exception {
        this.addBlockMetadata(block, BlockKind.EXPECT);
    }

    @Override
    public void visitWhenBlock(WhenBlock block) throws Exception {
        this.addBlockMetadata(block, BlockKind.WHEN);
    }

    @Override
    public void visitThenBlock(ThenBlock block) throws Exception {
        this.addBlockMetadata(block, BlockKind.THEN);
    }

    @Override
    public void visitCleanupBlock(CleanupBlock block) throws Exception {
        this.addBlockMetadata(block, BlockKind.CLEANUP);
    }

    @Override
    public void visitWhereBlock(WhereBlock block) throws Exception {
        this.addBlockMetadata(block, BlockKind.WHERE);
    }
}

