/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime;

import java.util.Iterator;
import java.util.List;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.control.SourceUnit;
import org.spockframework.runtime.ExpressionInfoConverter;
import org.spockframework.runtime.model.ExpressionInfo;
import org.spockframework.runtime.model.TextPosition;
import org.spockframework.runtime.model.TextRegion;
import org.spockframework.util.Assert;
import org.spockframework.util.TextUtil;

public class ExpressionInfoBuilder {
    private final String text;
    private final String adjustedText;
    private final TextPosition startPos;
    private final List<Object> values;
    private final Integer notRecordedVarNumberBecauseOfException;
    private final Throwable exception;
    private final String[] lines;

    public ExpressionInfoBuilder(String text, TextPosition startPos, List<Object> values, Integer notRecordedVarNumberBecauseOfException, Throwable exception) {
        this.text = text;
        this.startPos = startPos;
        this.values = values;
        this.notRecordedVarNumberBecauseOfException = notRecordedVarNumberBecauseOfException;
        this.exception = exception;
        this.adjustedText = TextUtil.repeatChar(' ', startPos.getColumnIndex()) + text;
        this.lines = this.adjustedText.split("\n");
    }

    public ExpressionInfo build() {
        try {
            SourceUnit unit = SourceUnit.create((String)"Spec expression", (String)this.adjustedText);
            unit.parse();
            unit.completePhase();
            unit.convert();
            BlockStatement blockStat = unit.getAST().getStatementBlock();
            Assert.that(blockStat != null && blockStat.getStatements().size() == 1);
            Statement stat = (Statement)blockStat.getStatements().get(0);
            Assert.that(stat instanceof ExpressionStatement);
            Expression expr = ((ExpressionStatement)stat).getExpression();
            ExpressionInfo exprInfo = (ExpressionInfo)new ExpressionInfoConverter(this.lines).convert(expr);
            List<ExpressionInfo> inPostfixOrder = exprInfo.inPostfixOrder(false);
            for (int variableNumber = 0; variableNumber < inPostfixOrder.size(); ++variableNumber) {
                ExpressionInfo info = inPostfixOrder.get(variableNumber);
                info.setText(this.findText(info.getRegion()));
                if (this.notRecordedVarNumberBecauseOfException != null && variableNumber == this.notRecordedVarNumberBecauseOfException) {
                    info.setValue(this.exception);
                } else if (this.values.size() > variableNumber) {
                    info.setValue(this.values.get(variableNumber));
                } else {
                    info.setValue(ExpressionInfo.VALUE_NOT_AVAILABLE);
                }
                if (this.startPos.getLineIndex() <= 0) continue;
                info.shiftVertically(this.startPos.getLineIndex());
            }
            return exprInfo;
        }
        catch (Throwable t) {
            ExpressionInfo expressionInfo = new ExpressionInfo(TextRegion.create(TextPosition.create(1, 1), TextPosition.create(1, 1)), TextPosition.create(1, 1), null, new ExpressionInfo[0]);
            expressionInfo.setText(this.text);
            expressionInfo.setValue(this.lastOrNull(this.values));
            return expressionInfo;
        }
    }

    private Object lastOrNull(Iterable<Object> values) {
        Object result = null;
        Iterator<Object> i$ = values.iterator();
        while (i$.hasNext()) {
            Object value;
            result = value = i$.next();
        }
        return result;
    }

    private String findText(TextRegion region) {
        if (region == TextRegion.NOT_AVAILABLE) {
            return "(n/a)";
        }
        try {
            StringBuilder text = new StringBuilder();
            for (int i = 0; i <= region.getEnd().getLineIndex(); ++i) {
                String line = this.lines[i];
                if (i == region.getEnd().getLineIndex()) {
                    line = line.substring(0, region.getEnd().getColumnIndex());
                }
                if (i == region.getStart().getLineIndex()) {
                    line = line.substring(region.getStart().getColumnIndex());
                }
                text.append(line);
                if (i == region.getEnd().getLineIndex()) continue;
                text.append('\n');
            }
            return text.toString();
        }
        catch (IndexOutOfBoundsException e) {
            return "(n/a)";
        }
    }
}

