/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;
import org.spockframework.runtime.model.ExpressionInfo;
import org.spockframework.runtime.model.TextPosition;

public class ExpressionInfoRenderer {
    private static final Pattern NEWLINE_PATTERN = Pattern.compile("\r\n|\r|\n");
    private final ExpressionInfo expr;
    private final List<StringBuilder> lines = new ArrayList<StringBuilder>();
    private final List<Integer> startColumns = new ArrayList<Integer>();

    private ExpressionInfoRenderer(ExpressionInfo expr) {
        TextPosition start = expr.getRegion().getStart();
        if (start.getLine() != 1 || start.getColumn() != 1) {
            throw new IllegalArgumentException("can only print expressions starting at 1,1");
        }
        if (expr.getRegion().getEnd().getLine() != 1) {
            throw new IllegalArgumentException("can only print expressions ending on line 1");
        }
        this.expr = expr;
    }

    public static String render(ExpressionInfo expr) {
        return new ExpressionInfoRenderer(expr).render();
    }

    private String render() {
        this.placeText();
        this.placeValues();
        return this.linesToString();
    }

    private void placeText() {
        this.lines.add(new StringBuilder(this.expr.getText()));
        this.startColumns.add(0);
    }

    private void placeValues() {
        Comparator<ExpressionInfo> comparator = new Comparator<ExpressionInfo>(){

            @Override
            public int compare(ExpressionInfo expr1, ExpressionInfo expr2) {
                return expr2.getAnchor().getColumn() - expr1.getAnchor().getColumn();
            }
        };
        for (ExpressionInfo expr : this.expr.inCustomOrder(true, comparator)) {
            this.placeValue(expr);
        }
    }

    private void placeValue(ExpressionInfo expr) {
        int endColumn;
        String str = expr.getRenderedValue();
        if (str == null) {
            return;
        }
        int startColumn = expr.getAnchor().getColumn();
        if (startColumn < 1) {
            return;
        }
        String[] strs = NEWLINE_PATTERN.split(str);
        int n = endColumn = strs.length == 1 ? expr.getAnchor().getColumn() + str.length() : Integer.MAX_VALUE;
        if (this.lines.size() == 1) {
            this.lines.add(new StringBuilder());
            this.startColumns.add(0);
        }
        for (int i = 1; i < this.lines.size(); ++i) {
            if (endColumn < this.startColumns.get(i)) {
                ExpressionInfoRenderer.placeString(this.lines.get(i), str, startColumn);
                this.startColumns.set(i, startColumn);
                return;
            }
            ExpressionInfoRenderer.placeString(this.lines.get(i), "|", startColumn);
            if (i <= 1) continue;
            this.startColumns.set(i, startColumn + 1);
        }
        for (String s : strs) {
            StringBuilder newLine = new StringBuilder();
            this.lines.add(newLine);
            ExpressionInfoRenderer.placeString(newLine, s, startColumn);
            this.startColumns.add(startColumn);
        }
    }

    private String linesToString() {
        StringBuilder result = new StringBuilder();
        for (StringBuilder line : this.lines) {
            result.append((CharSequence)line).append('\n');
        }
        return result.toString();
    }

    private static void placeString(StringBuilder line, String str, int column) {
        while (line.length() < column) {
            line.append(' ');
        }
        line.replace(column - 1, column - 1 + str.length(), str);
    }
}

