/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime;

import org.junit.internal.AssumptionViolatedException;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.MultipleFailureException;
import org.spockframework.runtime.Condition;
import org.spockframework.runtime.ConditionNotSatisfiedError;
import org.spockframework.runtime.IRunListener;
import org.spockframework.runtime.IRunSupervisor;
import org.spockframework.runtime.IStackTraceFilter;
import org.spockframework.runtime.MasterRunListener;
import org.spockframework.runtime.SpockComparisonFailure;
import org.spockframework.runtime.SpockExecutionException;
import org.spockframework.runtime.condition.IObjectRenderer;
import org.spockframework.runtime.model.ErrorInfo;
import org.spockframework.runtime.model.ExpressionInfo;
import org.spockframework.runtime.model.FeatureInfo;
import org.spockframework.runtime.model.IterationInfo;
import org.spockframework.runtime.model.SpecInfo;
import org.spockframework.util.InternalSpockError;
import org.spockframework.util.TextUtil;

public class JUnitSupervisor
implements IRunSupervisor {
    private final SpecInfo spec;
    private final RunNotifier notifier;
    private final IStackTraceFilter filter;
    private final IRunListener masterListener;
    private final IObjectRenderer<Object> diffedObjectRenderer;
    private FeatureInfo currentFeature;
    private IterationInfo currentIteration;
    private int iterationCount;
    private boolean errorSinceLastReset;

    public JUnitSupervisor(SpecInfo spec, RunNotifier notifier, IStackTraceFilter filter, IObjectRenderer<Object> diffedObjectRenderer) {
        this.spec = spec;
        this.notifier = notifier;
        this.filter = filter;
        this.masterListener = new MasterRunListener(spec);
        this.diffedObjectRenderer = diffedObjectRenderer;
    }

    @Override
    public void beforeSpec(SpecInfo spec) {
        this.masterListener.beforeSpec(spec);
    }

    @Override
    public void beforeFeature(FeatureInfo feature) {
        this.masterListener.beforeFeature(feature);
        this.currentFeature = feature;
        if (!feature.isReportIterations()) {
            this.notifier.fireTestStarted(feature.getDescription());
        }
        if (feature.isParameterized()) {
            this.iterationCount = 0;
            this.errorSinceLastReset = false;
        }
    }

    @Override
    public void beforeIteration(IterationInfo iteration) {
        this.masterListener.beforeIteration(iteration);
        this.currentIteration = iteration;
        ++this.iterationCount;
        if (this.currentFeature.isReportIterations()) {
            this.notifier.fireTestStarted(iteration.getDescription());
        }
    }

    @Override
    public int error(ErrorInfo error) {
        Throwable exception = error.getException();
        if (exception instanceof MultipleFailureException) {
            return this.handleMultipleFailures(error);
        }
        if (this.isFailedEqualityComparison(exception)) {
            exception = this.convertToComparisonFailure(exception);
        }
        this.filter.filter(exception);
        Failure failure = new Failure(this.getCurrentDescription(), exception);
        if (exception instanceof AssumptionViolatedException) {
            if (this.currentIteration == null || !this.currentFeature.isParameterized() || this.currentFeature.isReportIterations()) {
                this.notifier.fireTestAssumptionFailed(failure);
            }
        } else {
            this.masterListener.error(error);
            this.notifier.fireTestFailure(failure);
        }
        this.errorSinceLastReset = true;
        return this.statusFor(error);
    }

    private int handleMultipleFailures(ErrorInfo error) {
        MultipleFailureException multiFailure = (MultipleFailureException)error.getException();
        int runStatus = 0;
        for (Throwable failure : multiFailure.getFailures()) {
            runStatus = this.error(new ErrorInfo(error.getMethod(), failure));
        }
        return runStatus;
    }

    private boolean isFailedEqualityComparison(Throwable exception) {
        if (!(exception instanceof ConditionNotSatisfiedError)) {
            return false;
        }
        ConditionNotSatisfiedError conditionNotSatisfiedError = (ConditionNotSatisfiedError)((Object)exception);
        Condition condition = conditionNotSatisfiedError.getCondition();
        ExpressionInfo expr = condition.getExpression();
        return expr != null && expr.isEqualityComparison() && conditionNotSatisfiedError.getCause() == null;
    }

    private Throwable convertToComparisonFailure(Throwable exception) {
        assert (this.isFailedEqualityComparison(exception));
        ConditionNotSatisfiedError conditionNotSatisfiedError = (ConditionNotSatisfiedError)((Object)exception);
        Condition condition = conditionNotSatisfiedError.getCondition();
        ExpressionInfo expr = condition.getExpression();
        String actual = this.renderValue(expr.getChildren().get(0).getValue());
        String expected = this.renderValue(expr.getChildren().get(1).getValue());
        SpockComparisonFailure failure = new SpockComparisonFailure(condition, expected, actual);
        failure.setStackTrace(exception.getStackTrace());
        if (conditionNotSatisfiedError.getCause() != null) {
            failure.initCause(conditionNotSatisfiedError.getCause());
        }
        return failure;
    }

    private String renderValue(Object value) {
        try {
            return this.diffedObjectRenderer.render(value);
        }
        catch (Throwable t) {
            return "Failed to render value due to:\n\n" + TextUtil.printStackTrace(t);
        }
    }

    private int statusFor(ErrorInfo error) {
        switch (error.getMethod().getKind()) {
            case DATA_PROCESSOR: 
            case INITIALIZER: 
            case ITERATION_EXECUTION: 
            case SETUP: 
            case CLEANUP: 
            case FEATURE: {
                return 5;
            }
            case FEATURE_EXECUTION: 
            case DATA_PROVIDER: {
                return 9;
            }
            case SHARED_INITIALIZER: 
            case SETUP_SPEC: 
            case CLEANUP_SPEC: 
            case SPEC_EXECUTION: {
                return 17;
            }
        }
        throw new InternalSpockError("unknown method kind");
    }

    @Override
    public void afterIteration(IterationInfo iteration) {
        this.masterListener.afterIteration(iteration);
        if (this.currentFeature.isReportIterations()) {
            this.notifier.fireTestFinished(iteration.getDescription());
        }
        this.currentIteration = null;
    }

    @Override
    public void afterFeature(FeatureInfo feature) {
        if (feature.isParameterized() && this.iterationCount == 0 && !this.errorSinceLastReset) {
            this.notifier.fireTestFailure(new Failure(feature.getDescription(), (Throwable)new SpockExecutionException("Data provider has no data")));
        }
        this.masterListener.afterFeature(feature);
        if (!feature.isReportIterations()) {
            this.notifier.fireTestFinished(feature.getDescription());
        }
        this.currentFeature = null;
    }

    @Override
    public void afterSpec(SpecInfo spec) {
        this.masterListener.afterSpec(spec);
    }

    @Override
    public void specSkipped(SpecInfo spec) {
        this.masterListener.specSkipped(spec);
        this.notifier.fireTestIgnored(spec.getDescription());
    }

    @Override
    public void featureSkipped(FeatureInfo feature) {
        this.masterListener.featureSkipped(feature);
        this.notifier.fireTestIgnored(feature.getDescription());
    }

    private Description getCurrentDescription() {
        if (this.currentIteration != null && this.currentFeature.isReportIterations()) {
            return this.currentIteration.getDescription();
        }
        if (this.currentFeature != null) {
            return this.currentFeature.getDescription();
        }
        return this.spec.getDescription();
    }
}

