/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.mock.runtime;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.spockframework.mock.CannotCreateMockException;
import org.spockframework.mock.IMockInvocation;
import org.spockframework.mock.IResponseGenerator;
import org.spockframework.util.ReflectionUtil;

public class DefaultMethodInvoker
implements IResponseGenerator {
    private final Object target;
    private final Method method;
    private final Object[] arguments;

    public DefaultMethodInvoker(Object target, Method method, Object[] arguments) {
        this.target = target;
        this.method = method;
        this.arguments = arguments;
    }

    @Override
    public Object respond(IMockInvocation invocation) {
        Object boundHandle = null;
        Method invokeWithArgumentsMethod = null;
        try {
            Class<?> lookupClass = Class.forName("java.lang.invoke.MethodHandles$Lookup");
            Field field = lookupClass.getDeclaredField("IMPL_LOOKUP");
            field.setAccessible(true);
            Object implLookup = field.get(null);
            Method unreflectSpecialMethod = lookupClass.getMethod("unreflectSpecial", Method.class, Class.class);
            Object specialHandle = unreflectSpecialMethod.invoke(implLookup, this.method, this.method.getDeclaringClass());
            Method bindToMethod = specialHandle.getClass().getMethod("bindTo", Object.class);
            boundHandle = bindToMethod.invoke(specialHandle, this.target);
            invokeWithArgumentsMethod = boundHandle.getClass().getMethod("invokeWithArguments", Object[].class);
        }
        catch (Exception e) {
            throw new CannotCreateMockException(this.target.getClass(), "Failed to invoke default method '" + this.method.getName() + "'", e);
        }
        Object result = ReflectionUtil.invokeMethod(boundHandle, invokeWithArgumentsMethod, new Object[]{this.arguments});
        return result;
    }
}

