/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.report.log;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.spockframework.report.log.IReportLogListener;
import org.spockframework.report.log.ReportLogMerger;
import org.spockframework.runtime.extension.ExtensionException;
import org.spockframework.util.IStoppable;
import org.spockframework.util.IoUtil;
import org.spockframework.util.JsonWriter;

public class ReportLogWriter
implements IReportLogListener,
IStoppable {
    private final File logFile;
    private String prefix = "";
    private String postfix = "";
    private boolean prettyPrint = true;
    private boolean liveUpdate = true;
    private final ReportLogMerger logMerger = new ReportLogMerger();
    private final Map<String, Map<String, Object>> pendingLogs = new HashMap<String, Map<String, Object>>();
    private Writer fileWriter;
    private JsonWriter jsonWriter;

    public ReportLogWriter(File logFile) {
        this.logFile = logFile;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setPostfix(String postfix) {
        this.postfix = postfix;
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    public void setLiveUpdate(boolean liveUpdate) {
        this.liveUpdate = liveUpdate;
    }

    public void start() {
        this.logFile.getParentFile().mkdirs();
        try {
            this.logFile.createNewFile();
            this.fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(this.logFile), "utf-8");
        }
        catch (IOException e) {
            throw new ExtensionException("Error creating report log file: " + this.logFile, e);
        }
        this.jsonWriter = new JsonWriter(this.fileWriter);
        this.jsonWriter.setPrettyPrint(this.prettyPrint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        try {
            for (Map<String, Object> spec : this.pendingLogs.values()) {
                this.writeLog(spec);
            }
        }
        catch (Throwable throwable) {
            IoUtil.closeQuietly(this.fileWriter);
            throw throwable;
        }
        IoUtil.closeQuietly(this.fileWriter);
    }

    @Override
    public void emitted(Map<String, Object> log) {
        String key = log.get("package") + "." + log.get("name");
        Map<String, Object> mergedLog = this.logMerger.merge(this.pendingLogs.get(key), log);
        if (mergedLog.get("result") != null) {
            this.writeLog(mergedLog);
            this.pendingLogs.remove(key);
        } else {
            this.pendingLogs.put(key, mergedLog);
        }
    }

    private void writeLog(Map log) {
        try {
            this.fileWriter.write(this.prefix);
            this.fileWriter.write("[");
            this.jsonWriter.write(log);
            this.fileWriter.write("]");
            this.fileWriter.write(this.postfix);
            if (this.liveUpdate) {
                this.fileWriter.flush();
            }
        }
        catch (IOException e) {
            throw new ExtensionException("Error writing to report log file: " + this.logFile, e);
        }
    }
}

