/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.compiler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ArrayExpression;
import org.codehaus.groovy.ast.expr.AttributeExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.BitwiseNegationExpression;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.CastExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ClosureListExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.ElvisOperatorExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.FieldExpression;
import org.codehaus.groovy.ast.expr.GStringExpression;
import org.codehaus.groovy.ast.expr.LambdaExpression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.MapEntryExpression;
import org.codehaus.groovy.ast.expr.MapExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.MethodPointerExpression;
import org.codehaus.groovy.ast.expr.MethodReferenceExpression;
import org.codehaus.groovy.ast.expr.NamedArgumentListExpression;
import org.codehaus.groovy.ast.expr.NotExpression;
import org.codehaus.groovy.ast.expr.PostfixExpression;
import org.codehaus.groovy.ast.expr.PrefixExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.RangeExpression;
import org.codehaus.groovy.ast.expr.SpreadExpression;
import org.codehaus.groovy.ast.expr.SpreadMapExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.TernaryExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.UnaryMinusExpression;
import org.codehaus.groovy.ast.expr.UnaryPlusExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.AssertStatement;
import org.codehaus.groovy.ast.stmt.CatchStatement;
import org.codehaus.groovy.ast.stmt.EmptyStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.stmt.TryCatchStatement;
import org.codehaus.groovy.classgen.BytecodeExpression;
import org.codehaus.groovy.syntax.Types;
import org.spockframework.compat.groovy2.GroovyCodeVisitorCompat;
import org.spockframework.compiler.AstUtil;
import org.spockframework.compiler.IRewriteResources;
import org.spockframework.compiler.OldValueExpression;
import org.spockframework.util.AbstractExpressionConverter;
import org.spockframework.util.Assert;
import org.spockframework.util.TextUtil;

public class ConditionRewriter
extends AbstractExpressionConverter<Expression>
implements GroovyCodeVisitorCompat {
    private static final Pattern COMMENTS_PATTERN = Pattern.compile("/\\*.*?\\*/|//.*$");
    private final IRewriteResources resources;
    private int recordCount = 0;

    private ConditionRewriter(IRewriteResources resources) {
        this.resources = resources;
    }

    public static Statement rewriteExplicitCondition(AssertStatement stat, IRewriteResources resources) {
        ConditionRewriter rewriter = new ConditionRewriter(resources);
        Expression message = AstUtil.getAssertionMessage(stat);
        return rewriter.rewriteCondition((Statement)stat, stat.getBooleanExpression().getExpression(), message, true);
    }

    public static Statement rewriteImplicitCondition(ExpressionStatement stat, IRewriteResources resources) {
        ConditionRewriter rewriter = new ConditionRewriter(resources);
        return rewriter.rewriteCondition((Statement)stat, stat.getExpression(), null, false);
    }

    public void visitMethodCallExpression(MethodCallExpression expr) {
        boolean objectExprSeenAsMethodNameAtRuntime = !expr.isImplicitThis() && expr.getObjectExpression() instanceof VariableExpression && "call".equals(expr.getMethodAsString()) && (!AstUtil.hasPlausibleSourcePosition((ASTNode)expr.getMethod()) || expr.getMethod().getColumnNumber() == expr.getObjectExpression().getColumnNumber());
        MethodCallExpression conversion = new MethodCallExpression(expr.isImplicitThis() ? expr.getObjectExpression() : (Expression)this.convert(expr.getObjectExpression()), objectExprSeenAsMethodNameAtRuntime ? expr.getMethod() : (Expression)this.convert(expr.getMethod()), (Expression)this.convert(expr.getArguments()));
        conversion.setSafe(expr.isSafe());
        conversion.setSpreadSafe(expr.isSpreadSafe());
        conversion.setSourcePosition((ASTNode)expr);
        this.result = this.record((Expression)conversion);
    }

    public void visitStaticMethodCallExpression(StaticMethodCallExpression expr) {
        StaticMethodCallExpression conversion = new StaticMethodCallExpression(expr.getOwnerType(), this.recordNa(expr.getMethod()), (Expression)this.convert(expr.getArguments()));
        conversion.setSourcePosition((ASTNode)expr);
        conversion.setMetaMethod(expr.getMetaMethod());
        this.result = this.record((Expression)conversion);
    }

    public void visitBytecodeExpression(BytecodeExpression expr) {
        this.unsupported();
    }

    public void visitArgumentlistExpression(ArgumentListExpression expr) {
        ArgumentListExpression conversion = new ArgumentListExpression(this.convertAll(expr.getExpressions()));
        conversion.setSourcePosition((ASTNode)expr);
        this.result = this.recordNa(conversion);
    }

    public void visitPropertyExpression(PropertyExpression expr) {
        PropertyExpression conversion = new PropertyExpression(expr.isImplicitThis() ? expr.getObjectExpression() : (Expression)this.convert(expr.getObjectExpression()), expr.getProperty(), expr.isSafe());
        conversion.setSourcePosition((ASTNode)expr);
        conversion.setSpreadSafe(expr.isSpreadSafe());
        conversion.setStatic(expr.isStatic());
        conversion.setImplicitThis(expr.isImplicitThis());
        this.result = this.record((Expression)conversion);
    }

    public void visitAttributeExpression(AttributeExpression expr) {
        AttributeExpression conversion = new AttributeExpression(expr.isImplicitThis() ? expr.getObjectExpression() : (Expression)this.convert(expr.getObjectExpression()), expr.getProperty(), expr.isSafe());
        conversion.setSourcePosition((ASTNode)expr);
        conversion.setSpreadSafe(expr.isSpreadSafe());
        conversion.setStatic(expr.isStatic());
        conversion.setImplicitThis(expr.isImplicitThis());
        this.result = this.record((Expression)conversion);
    }

    public void visitFieldExpression(FieldExpression expr) {
        this.result = this.record((Expression)expr);
    }

    public void visitMethodPointerExpression(MethodPointerExpression expr) {
        MethodPointerExpression conversion = new MethodPointerExpression((Expression)this.convert(expr.getExpression()), (Expression)this.convert(expr.getMethodName()));
        conversion.setSourcePosition((ASTNode)expr);
        this.result = this.record((Expression)conversion);
    }

    @Override
    public void visitMethodReferenceExpression(MethodReferenceExpression expr) {
        this.visitMethodPointerExpression((MethodPointerExpression)expr);
    }

    public void visitVariableExpression(VariableExpression expr) {
        if (expr instanceof OldValueExpression) {
            Expression originalExpr = ((OldValueExpression)expr).getOrginalExpression();
            originalExpr.visit((GroovyCodeVisitor)this);
            this.result = expr;
            return;
        }
        this.result = this.record((Expression)expr);
    }

    public void visitDeclarationExpression(DeclarationExpression expr) {
        this.unsupported();
    }

    public void visitBinaryExpression(BinaryExpression expr) {
        Expression convertedLeftExpression = Types.ofType((int)expr.getOperation().getType(), (int)1100) ? this.convertAndRecordNa(expr.getLeftExpression()) : (Expression)this.convert(expr.getLeftExpression());
        Expression convertedRightExpression = (Expression)this.convert(expr.getRightExpression());
        BinaryExpression conversion = Types.ofType((int)expr.getOperation().getType(), (int)544) ? AstUtil.createDirectMethodCall(convertedRightExpression, this.resources.getAstNodeCache().Class_IsInstance, convertedLeftExpression) : new BinaryExpression(convertedLeftExpression, expr.getOperation(), convertedRightExpression);
        conversion.setSourcePosition((ASTNode)expr);
        this.result = this.record((Expression)conversion);
    }

    public void visitConstantExpression(ConstantExpression expr) {
        this.result = this.record((Expression)expr);
    }

    public void visitClassExpression(ClassExpression expr) {
        this.result = expr;
        if (!AstUtil.hasPlausibleSourcePosition((ASTNode)expr)) {
            return;
        }
        String text = COMMENTS_PATTERN.matcher(this.resources.getSourceText((ASTNode)expr)).replaceAll("");
        this.recordCount += text == null ? 0 : TextUtil.countOccurrences(text, '.');
        this.result = this.record((Expression)expr);
    }

    public void visitUnaryMinusExpression(UnaryMinusExpression expr) {
        UnaryMinusExpression conversion = new UnaryMinusExpression((Expression)this.convert(expr.getExpression()));
        conversion.setSourcePosition((ASTNode)expr);
        this.result = this.record((Expression)conversion);
    }

    public void visitUnaryPlusExpression(UnaryPlusExpression expr) {
        UnaryPlusExpression conversion = new UnaryPlusExpression((Expression)this.convert(expr.getExpression()));
        conversion.setSourcePosition((ASTNode)expr);
        this.result = this.record((Expression)conversion);
    }

    public void visitBitwiseNegationExpression(BitwiseNegationExpression expr) {
        BitwiseNegationExpression conversion = new BitwiseNegationExpression((Expression)this.convert(expr.getExpression()));
        conversion.setSourcePosition((ASTNode)expr);
        this.result = this.record((Expression)conversion);
    }

    public void visitCastExpression(CastExpression expr) {
        CastExpression conversion = new CastExpression(expr.getType(), (Expression)this.convert(expr.getExpression()), expr.isIgnoringAutoboxing());
        conversion.setSourcePosition((ASTNode)expr);
        conversion.setCoerce(expr.isCoerce());
        this.result = this.record((Expression)conversion);
    }

    public void visitClosureListExpression(ClosureListExpression expr) {
        this.unsupported();
    }

    public void visitNotExpression(NotExpression expr) {
        NotExpression conversion = new NotExpression((Expression)this.convert(expr.getExpression()));
        conversion.setSourcePosition((ASTNode)expr);
        this.result = this.record((Expression)conversion);
    }

    public void visitListExpression(ListExpression expr) {
        ListExpression conversion = new ListExpression(this.convertAll(expr.getExpressions()));
        conversion.setSourcePosition((ASTNode)expr);
        this.result = this.record((Expression)conversion);
    }

    public void visitRangeExpression(RangeExpression expr) {
        RangeExpression conversion = new RangeExpression((Expression)this.convert(expr.getFrom()), (Expression)this.convert(expr.getTo()), expr.isInclusive());
        conversion.setSourcePosition((ASTNode)expr);
        this.result = this.record((Expression)conversion);
    }

    public void visitMapExpression(MapExpression expr) {
        boolean namedArgumentListExpr = expr instanceof NamedArgumentListExpression;
        NamedArgumentListExpression conversion = namedArgumentListExpr ? new NamedArgumentListExpression(this.convertAll(expr.getMapEntryExpressions())) : new MapExpression(this.convertAll(expr.getMapEntryExpressions()));
        conversion.setSourcePosition((ASTNode)expr);
        this.result = namedArgumentListExpr ? (Expression)this.recordNa(conversion) : this.record((Expression)conversion);
    }

    public void visitMapEntryExpression(MapEntryExpression expr) {
        MapEntryExpression conversion = new MapEntryExpression((Expression)this.convert(expr.getKeyExpression()), (Expression)this.convert(expr.getValueExpression()));
        conversion.setSourcePosition((ASTNode)expr);
        this.result = this.recordNa(conversion);
    }

    public void visitConstructorCallExpression(ConstructorCallExpression expr) {
        ConstructorCallExpression conversion = new ConstructorCallExpression(expr.getType(), (Expression)this.convert(expr.getArguments()));
        conversion.setSourcePosition((ASTNode)expr);
        conversion.setUsingAnonymousInnerClass(expr.isUsingAnonymousInnerClass());
        this.result = this.record((Expression)conversion);
    }

    public void visitGStringExpression(GStringExpression expr) {
        GStringExpression conversion = new GStringExpression(expr.getText(), expr.getStrings(), this.convertAll(expr.getValues()));
        conversion.setSourcePosition((ASTNode)expr);
        this.result = this.record((Expression)conversion);
    }

    public void visitArrayExpression(ArrayExpression expr) {
        ArrayExpression conversion = new ArrayExpression(expr.getElementType(), this.convertAll(expr.getExpressions()), expr.getSizeExpression() == null ? null : this.convertAll(expr.getSizeExpression()));
        conversion.setSourcePosition((ASTNode)expr);
        this.result = this.record((Expression)conversion);
    }

    public void visitSpreadExpression(SpreadExpression expr) {
        SpreadExpression conversion = new SpreadExpression((Expression)this.convert(expr.getExpression()));
        conversion.setSourcePosition((ASTNode)expr);
        this.result = this.recordNa(conversion);
    }

    public void visitSpreadMapExpression(SpreadMapExpression expr) {
        this.result = this.recordNa(expr);
    }

    public void visitTernaryExpression(TernaryExpression expr) {
        TernaryExpression conversion = new TernaryExpression(this.convertCompatibly(expr.getBooleanExpression()), (Expression)this.convert(expr.getTrueExpression()), (Expression)this.convert(expr.getFalseExpression()));
        conversion.setSourcePosition((ASTNode)expr);
        this.result = this.record((Expression)conversion);
    }

    public void visitShortTernaryExpression(ElvisOperatorExpression expr) {
        ElvisOperatorExpression conversion = new ElvisOperatorExpression((Expression)this.convert(expr.getTrueExpression()), (Expression)this.convert(expr.getFalseExpression()));
        conversion.setSourcePosition((ASTNode)expr);
        this.result = this.record((Expression)conversion);
    }

    public void visitPrefixExpression(PrefixExpression expr) {
        PrefixExpression conversion = new PrefixExpression(expr.getOperation(), this.convertAndRecordNa(expr.getExpression()));
        conversion.setSourcePosition((ASTNode)expr);
        this.result = this.record((Expression)conversion);
    }

    public void visitPostfixExpression(PostfixExpression expr) {
        PostfixExpression conversion = new PostfixExpression(this.convertAndRecordNa(expr.getExpression()), expr.getOperation());
        conversion.setSourcePosition((ASTNode)expr);
        this.result = this.record((Expression)conversion);
    }

    public void visitBooleanExpression(BooleanExpression expr) {
        BooleanExpression conversion = new BooleanExpression((Expression)this.convert(expr.getExpression()));
        conversion.setSourcePosition((ASTNode)expr);
        this.result = this.recordNa(conversion);
    }

    public void visitClosureExpression(ClosureExpression expr) {
        this.result = this.record((Expression)expr);
    }

    @Override
    public void visitLambdaExpression(LambdaExpression expr) {
        this.visitClosureExpression((ClosureExpression)expr);
    }

    public void visitTupleExpression(TupleExpression expr) {
        TupleExpression conversion = new TupleExpression(this.convertAllAndRecordNa(expr.getExpressions()));
        conversion.setSourcePosition((ASTNode)expr);
        this.result = this.recordNa(conversion);
    }

    private Expression record(Expression expr) {
        MethodCallExpression result = AstUtil.createDirectMethodCall((Expression)new VariableExpression("$spock_valueRecorder"), this.resources.getAstNodeCache().ValueRecorder_Record, (Expression)new ArgumentListExpression((Expression)AstUtil.createDirectMethodCall((Expression)new VariableExpression("$spock_valueRecorder"), this.resources.getAstNodeCache().ValueRecorder_StartRecordingValue, (Expression)new ArgumentListExpression((Expression)new ConstantExpression((Object)this.recordCount++))), expr));
        if (expr instanceof CastExpression) {
            return new CastExpression(expr.getType(), (Expression)result);
        }
        return result;
    }

    private Expression realizeNas(Expression expr) {
        return AstUtil.createDirectMethodCall((Expression)new VariableExpression("$spock_valueRecorder"), this.resources.getAstNodeCache().ValueRecorder_RealizeNas, (Expression)new ArgumentListExpression((Expression)new ConstantExpression((Object)this.recordCount), expr));
    }

    private <T> T recordNa(T expr) {
        ++this.recordCount;
        return expr;
    }

    private Expression convertAndRecordNa(Expression expr) {
        return this.unrecord((Expression)this.convert(expr));
    }

    private List<Expression> convertAllAndRecordNa(List<Expression> expressions) {
        ArrayList<Expression> conversions = new ArrayList<Expression>(expressions.size());
        for (Expression expr : expressions) {
            conversions.add(this.convertAndRecordNa(expr));
        }
        return conversions;
    }

    private <T extends Expression> T convertCompatibly(T expr) {
        Expression conversion = (Expression)this.convert(expr);
        Assert.that(expr.getClass().isInstance(conversion));
        return (T)conversion;
    }

    private Expression unrecord(Expression expr) {
        if (!(expr instanceof MethodCallExpression)) {
            return expr;
        }
        MethodCallExpression methodExpr = (MethodCallExpression)expr;
        Expression targetExpr = methodExpr.getObjectExpression();
        if (!(targetExpr instanceof VariableExpression)) {
            return expr;
        }
        VariableExpression var = (VariableExpression)targetExpr;
        if (!"$spock_valueRecorder".equals(var.getName())) {
            return expr;
        }
        if (!"record".equals(methodExpr.getMethodAsString())) {
            return expr;
        }
        return ((ArgumentListExpression)methodExpr.getArguments()).getExpression(1);
    }

    private int extractVariableNumber(Expression expr) {
        if (!(expr instanceof MethodCallExpression)) {
            return -1;
        }
        MethodCallExpression methodExpr = (MethodCallExpression)expr;
        Expression targetExpr = methodExpr.getObjectExpression();
        if (!(targetExpr instanceof VariableExpression)) {
            return -1;
        }
        VariableExpression var = (VariableExpression)targetExpr;
        if (!"$spock_valueRecorder".equals(var.getName())) {
            return -1;
        }
        if (!"record".equals(methodExpr.getMethodAsString())) {
            return -1;
        }
        Expression startRecordingEpr = ((ArgumentListExpression)methodExpr.getArguments()).getExpression(0);
        if (!(startRecordingEpr instanceof MethodCallExpression)) {
            return -1;
        }
        MethodCallExpression startRecording = (MethodCallExpression)startRecordingEpr;
        if (!"startRecordingValue".equals(startRecording.getMethodAsString())) {
            return -1;
        }
        Expression variableNumExpression = ((ArgumentListExpression)startRecording.getArguments()).getExpression(0);
        if (!(variableNumExpression instanceof ConstantExpression)) {
            return -1;
        }
        return (Integer)((ConstantExpression)variableNumExpression).getValue();
    }

    private Statement rewriteCondition(Statement conditionStat, Expression conditionExpr, Expression message, boolean explicit) {
        Statement result = this.rewriteCondition(conditionExpr, message, explicit);
        result.setSourcePosition((ASTNode)conditionStat);
        return result;
    }

    private Statement rewriteCondition(Expression expr, Expression message, boolean explicit) {
        if (expr instanceof MethodCallExpression && !((MethodCallExpression)expr).isSpreadSafe()) {
            MethodCallExpression methodCallExpression = (MethodCallExpression)expr;
            String methodName = AstUtil.getMethodName((Expression)methodCallExpression);
            if ("with".equals(methodName) || "verifyAll".equals(methodName)) {
                return this.surroundSpecialTryCatch(expr);
            }
            return this.rewriteMethodCondition(methodCallExpression, message, explicit);
        }
        if (expr instanceof StaticMethodCallExpression) {
            return this.rewriteStaticMethodCondition((StaticMethodCallExpression)expr, message, explicit);
        }
        return this.rewriteOtherCondition(expr, message);
    }

    private Statement rewriteMethodCondition(MethodCallExpression condition, Expression message, boolean explicit) {
        Expression converted = (Expression)this.convert((Expression)condition);
        MethodCallExpression rewritten = (MethodCallExpression)this.unrecord(converted);
        int lastVariableNum = this.extractVariableNumber(converted);
        ArrayList<Expression> args = new ArrayList<Expression>();
        args.add(rewritten.getObjectExpression());
        args.add(rewritten.getMethod());
        args.add(AstUtil.toArgumentArray(AstUtil.getArgumentList((Expression)rewritten), this.resources));
        args.add(this.realizeNas((Expression)new ConstantExpression((Object)rewritten.isSafe())));
        args.add((Expression)new ConstantExpression((Object)explicit));
        args.add((Expression)new ConstantExpression((Object)lastVariableNum));
        return this.surroundWithTryCatch((Expression)condition, message, this.rewriteToSpockRuntimeCall(this.resources.getAstNodeCache().SpockRuntime_VerifyMethodCondition, (Expression)condition, message, args));
    }

    private Statement rewriteStaticMethodCondition(StaticMethodCallExpression condition, Expression message, boolean explicit) {
        Expression converted = (Expression)this.convert((Expression)condition);
        StaticMethodCallExpression rewritten = (StaticMethodCallExpression)this.unrecord(converted);
        int lastVariableNum = this.extractVariableNumber(converted);
        ArrayList<Expression> args = new ArrayList<Expression>();
        args.add((Expression)new ClassExpression(rewritten.getOwnerType()));
        args.add((Expression)new ConstantExpression((Object)rewritten.getMethod()));
        args.add(AstUtil.toArgumentArray(AstUtil.getArgumentList((Expression)rewritten), this.resources));
        args.add(this.realizeNas((Expression)ConstantExpression.FALSE));
        args.add((Expression)new ConstantExpression((Object)explicit));
        args.add((Expression)new ConstantExpression((Object)lastVariableNum));
        return this.surroundWithTryCatch((Expression)condition, message, this.rewriteToSpockRuntimeCall(this.resources.getAstNodeCache().SpockRuntime_VerifyMethodCondition, (Expression)condition, message, args));
    }

    private Statement rewriteOtherCondition(Expression condition, Expression message) {
        Expression rewritten = (Expression)this.convert(condition);
        Expression executeAndVerify = this.rewriteToSpockRuntimeCall(this.resources.getAstNodeCache().SpockRuntime_VerifyCondition, condition, message, Collections.singletonList(rewritten));
        return this.surroundWithTryCatch(condition, message, executeAndVerify);
    }

    private TryCatchStatement surroundWithTryCatch(Expression condition, Expression message, Expression executeAndVerify) {
        TryCatchStatement tryCatchStatement = new TryCatchStatement((Statement)new ExpressionStatement(executeAndVerify), (Statement)EmptyStatement.INSTANCE);
        tryCatchStatement.addCatch(new CatchStatement(new Parameter(new ClassNode(Throwable.class), "throwable"), (Statement)new ExpressionStatement((Expression)AstUtil.createDirectMethodCall((Expression)new ClassExpression(this.resources.getAstNodeCache().SpockRuntime), this.resources.getAstNodeCache().SpockRuntime_ConditionFailedWithException, (Expression)new ArgumentListExpression(Arrays.asList(new VariableExpression("$spock_errorCollector"), new VariableExpression("$spock_valueRecorder"), new ConstantExpression((Object)this.resources.getSourceText((ASTNode)condition)), new ConstantExpression((Object)condition.getLineNumber()), new ConstantExpression((Object)condition.getColumnNumber()), message == null ? ConstantExpression.NULL : message, new VariableExpression("throwable")))))));
        return tryCatchStatement;
    }

    private TryCatchStatement surroundSpecialTryCatch(Expression executeAndVerify) {
        TryCatchStatement tryCatchStatement = new TryCatchStatement((Statement)new ExpressionStatement(executeAndVerify), (Statement)EmptyStatement.INSTANCE);
        tryCatchStatement.addCatch(new CatchStatement(new Parameter(new ClassNode(Throwable.class), "throwable"), (Statement)new ExpressionStatement((Expression)AstUtil.createDirectMethodCall((Expression)new ClassExpression(this.resources.getAstNodeCache().SpockRuntime), this.resources.getAstNodeCache().SpockRuntime_GroupConditionFailedWithException, (Expression)new ArgumentListExpression(Arrays.asList(new VariableExpression("$spock_errorCollector"), new VariableExpression("throwable")))))));
        return tryCatchStatement;
    }

    private Expression rewriteToSpockRuntimeCall(MethodNode method, Expression condition, Expression message, List<Expression> additionalArgs) {
        ArrayList<Object> args = new ArrayList<Object>();
        MethodCallExpression result = AstUtil.createDirectMethodCall((Expression)new ClassExpression(this.resources.getAstNodeCache().SpockRuntime), method, (Expression)new ArgumentListExpression(args));
        args.add(new VariableExpression("$spock_errorCollector", this.resources.getAstNodeCache().ErrorCollector));
        args.add(AstUtil.createDirectMethodCall((Expression)new VariableExpression("$spock_valueRecorder"), this.resources.getAstNodeCache().ValueRecorder_Reset, (Expression)ArgumentListExpression.EMPTY_ARGUMENTS));
        args.add(new ConstantExpression((Object)this.resources.getSourceText((ASTNode)condition)));
        args.add(new ConstantExpression((Object)condition.getLineNumber()));
        args.add(new ConstantExpression((Object)condition.getColumnNumber()));
        args.add(message == null ? ConstantExpression.NULL : message);
        args.addAll(additionalArgs);
        result.setSourcePosition((ASTNode)condition);
        return result;
    }
}

