/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.compiler;

import java.util.List;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.FieldExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.control.SourceUnit;
import org.spockframework.compiler.AstUtil;
import org.spockframework.compiler.IRewriteResources;
import org.spockframework.compiler.model.Block;
import org.spockframework.compiler.model.Method;
import org.spockframework.util.UnreachableCodeError;
import spock.lang.Shared;

public class InstanceFieldAccessChecker
extends ClassCodeVisitorSupport {
    private final IRewriteResources resources;

    public InstanceFieldAccessChecker(IRewriteResources resources) {
        this.resources = resources;
    }

    public void check(Expression expr) {
        expr.visit((GroovyCodeVisitor)this);
    }

    public void check(Method method) {
        for (Block block : method.getBlocks()) {
            for (Statement stat : (List)block.getAst()) {
                stat.visit((GroovyCodeVisitor)this);
            }
        }
    }

    public void visitVariableExpression(VariableExpression expr) {
        super.visitVariableExpression(expr);
        Variable var = expr.getAccessedVariable();
        if (!(var instanceof FieldNode)) {
            return;
        }
        this.checkFieldAccess((ASTNode)expr, (FieldNode)var);
    }

    public void visitFieldExpression(FieldExpression expr) {
        super.visitFieldExpression(expr);
        this.checkFieldAccess((ASTNode)expr, expr.getField());
    }

    protected SourceUnit getSourceUnit() {
        throw new UnreachableCodeError();
    }

    private void checkFieldAccess(ASTNode context, FieldNode field) {
        if (AstUtil.hasAnnotation((ASTNode)field, Shared.class) || field.isStatic()) {
            return;
        }
        this.resources.getErrorReporter().error(context, "Only @Shared and static fields may be accessed from here", new Object[0]);
    }
}

