/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.compiler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.control.SourceUnit;
import org.spockframework.compiler.AstNodeCache;
import org.spockframework.runtime.SpockRuntime;

public class RecorderScopeNameRewriter
extends ClassCodeVisitorSupport {
    private static final Set<String> REWRITE_METHOD_ARGS = new HashSet<String>(Arrays.asList("verifyCondition", "conditionFailedWithException", "groupConditionFailedWithException", "verifyMethodCondition"));
    private final AstNodeCache astNodeCache;
    private int valueRecorderIndex = -1;
    private int errorCollectorIndex = -1;

    public RecorderScopeNameRewriter(AstNodeCache astNodeCache) {
        this.astNodeCache = astNodeCache;
    }

    public void visitClosureExpression(ClosureExpression expression) {
        int oldValueRecorderIndex = this.valueRecorderIndex;
        int oldErrorCollectorIndex = this.errorCollectorIndex;
        super.visitClosureExpression(expression);
        this.valueRecorderIndex = oldValueRecorderIndex;
        this.errorCollectorIndex = oldErrorCollectorIndex;
    }

    public void visitDeclarationExpression(DeclarationExpression expression) {
        if (expression.isMultipleAssignmentDeclaration()) {
            return;
        }
        VariableExpression variableExpression = expression.getVariableExpression();
        if (this.isValueRecorderExpression(variableExpression)) {
            ++this.valueRecorderIndex;
            expression.setLeftExpression((Expression)this.valueRecorderExpression());
        } else if (this.isErrorCollectorExpression(variableExpression)) {
            ++this.errorCollectorIndex;
            expression.setLeftExpression((Expression)this.errorCollectorExpression());
        }
        super.visitDeclarationExpression(expression);
    }

    public void visitMethodCallExpression(MethodCallExpression call) {
        Expression objectExpression = call.getObjectExpression();
        if (objectExpression instanceof VariableExpression) {
            this.rewriteMethodObject(call, (VariableExpression)objectExpression);
        } else if (objectExpression instanceof ClassExpression) {
            this.rewriteArgumentList(call, (ClassExpression)objectExpression);
        }
        super.visitMethodCallExpression(call);
    }

    private void rewriteMethodObject(MethodCallExpression call, VariableExpression objectExpression) {
        if (this.isValueRecorderExpression(objectExpression)) {
            call.setObjectExpression((Expression)this.valueRecorderExpression());
        } else if (this.isErrorCollectorExpression(objectExpression)) {
            call.setObjectExpression((Expression)this.errorCollectorExpression());
        }
    }

    private void rewriteArgumentList(MethodCallExpression call, ClassExpression objectExpression) {
        String methodName;
        if (SpockRuntime.class.getName().equals(objectExpression.getType().getName()) && REWRITE_METHOD_ARGS.contains(methodName = call.getMethod().getText())) {
            ArrayList<VariableExpression> arguments = new ArrayList<VariableExpression>(((ArgumentListExpression)call.getArguments()).getExpressions());
            Expression expression = (Expression)arguments.get(0);
            if (expression instanceof VariableExpression && this.isErrorCollectorExpression((VariableExpression)expression)) {
                arguments.set(0, this.errorCollectorExpression());
            }
            if ((expression = (Expression)arguments.get(1)) instanceof VariableExpression && this.isValueRecorderExpression((VariableExpression)expression)) {
                arguments.set(1, this.valueRecorderExpression());
            }
            call.setArguments((Expression)new ArgumentListExpression(arguments));
        }
    }

    protected SourceUnit getSourceUnit() {
        throw new UnsupportedOperationException("getSourceUnit");
    }

    private VariableExpression errorCollectorExpression() {
        return new VariableExpression("$spock_errorCollector" + (this.errorCollectorIndex == 0 ? "" : String.valueOf(this.errorCollectorIndex)), this.astNodeCache.ErrorCollector);
    }

    private VariableExpression valueRecorderExpression() {
        return new VariableExpression("$spock_valueRecorder" + (this.valueRecorderIndex == 0 ? "" : String.valueOf(this.valueRecorderIndex)), this.astNodeCache.ValueRecorder);
    }

    private boolean isErrorCollectorExpression(VariableExpression variableExpression) {
        return "$spock_errorCollector".equals(variableExpression.getName());
    }

    private boolean isValueRecorderExpression(VariableExpression variableExpression) {
        return "$spock_valueRecorder".equals(variableExpression.getName());
    }
}

