/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.opentest4j.MultipleFailuresError;

public class ErrorCollector {
    private final boolean errorCollectionEnabled;
    private final List<Throwable> throwables = new CopyOnWriteArrayList<Throwable>();
    public static final String VALIDATE_COLLECTED_ERRORS = "validateCollectedErrors";

    public ErrorCollector(boolean enabled) {
        this.errorCollectionEnabled = enabled;
    }

    public <T extends Throwable> void collectOrThrow(T error) throws T {
        if (!this.errorCollectionEnabled) {
            throw error;
        }
        this.throwables.add(error);
    }

    public void validateCollectedErrors() {
        if (this.errorCollectionEnabled && !this.throwables.isEmpty()) {
            throw new MultipleFailuresError("", this.throwables);
        }
    }
}

