/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime;

import java.lang.reflect.Method;
import java.util.function.Predicate;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.discovery.ClassSelector;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.engine.discovery.MethodSelector;
import org.junit.platform.engine.discovery.UniqueIdSelector;
import org.junit.platform.engine.support.discovery.SelectorResolver;
import org.spockframework.runtime.SpecNode;
import org.spockframework.runtime.model.FeatureInfo;
import org.spockframework.runtime.model.SpecInfo;

public class MethodSelectorResolver
implements SelectorResolver {
    public SelectorResolver.Resolution resolve(MethodSelector selector, SelectorResolver.Context context) {
        String methodName = selector.getMethodName();
        Predicate<FeatureInfo> filter = feature -> ((Method)feature.getFeatureMethod().getReflection()).getName().equals(methodName) || methodName.equals(feature.getName());
        ClassSelector parentSelector = DiscoverySelectors.selectClass((Class)selector.getJavaClass());
        return this.resolve(context, (DiscoverySelector)parentSelector, filter);
    }

    SelectorResolver.Resolution resolve(SelectorResolver.Context context, DiscoverySelector parentSelector, Predicate<FeatureInfo> filter) {
        return context.resolve(parentSelector).map(testDescriptor -> this.handle((TestDescriptor)testDescriptor, filter)).map(descriptor -> SelectorResolver.Resolution.match((SelectorResolver.Match)SelectorResolver.Match.partial((TestDescriptor)descriptor))).orElseGet(SelectorResolver.Resolution::unresolved);
    }

    private TestDescriptor handle(TestDescriptor testDescriptor, Predicate<FeatureInfo> filter) {
        if (testDescriptor instanceof SpecNode) {
            SpecNode specNode = (SpecNode)testDescriptor;
            long count = ((SpecInfo)specNode.getNodeInfo()).getAllFeaturesInExecutionOrder().stream().filter(filter).peek(featureInfo -> featureInfo.setExcluded(false)).count();
            return count == 0L ? null : testDescriptor;
        }
        return null;
    }

    public SelectorResolver.Resolution resolve(UniqueIdSelector selector, SelectorResolver.Context context) {
        UniqueId uniqueId = selector.getUniqueId();
        UniqueId.Segment lastSegment = uniqueId.getLastSegment();
        if ("feature".equals(lastSegment.getType())) {
            String methodName = lastSegment.getValue();
            return this.resolve(context, (DiscoverySelector)DiscoverySelectors.selectUniqueId((UniqueId)uniqueId.removeLastSegment()), feature -> methodName.equals(((Method)feature.getFeatureMethod().getReflection()).getName()));
        }
        if ("iteration".equals(lastSegment.getType())) {
            return this.resolve(DiscoverySelectors.selectUniqueId((UniqueId)uniqueId.removeLastSegment()), context);
        }
        return SelectorResolver.Resolution.unresolved();
    }
}

