/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime;

import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.support.hierarchical.Node;
import org.opentest4j.TestAbortedException;
import org.spockframework.runtime.ParameterizedFeatureNode;
import org.spockframework.runtime.model.FeatureInfo;

class ParameterizedFeatureChildExecutor {
    private final ParameterizedFeatureNode parameterizedFeatureNode;
    private AtomicInteger executionCounter = new AtomicInteger();
    private Map<TestExecutionResult.Status, Queue<Throwable>> results = new ConcurrentHashMap<TestExecutionResult.Status, Queue<Throwable>>();
    private final Node.DynamicTestExecutor delegate;
    private EngineExecutionListener executionListener;

    ParameterizedFeatureChildExecutor(ParameterizedFeatureNode parameterizedFeatureNode, Node.DynamicTestExecutor delegate) {
        this.parameterizedFeatureNode = parameterizedFeatureNode;
        this.delegate = delegate;
        if (!((FeatureInfo)parameterizedFeatureNode.getNodeInfo()).isReportIterations()) {
            this.executionListener = new EngineExecutionListener(){

                public void executionSkipped(TestDescriptor testDescriptor, String reason) {
                    ParameterizedFeatureChildExecutor.this.results.computeIfAbsent(TestExecutionResult.Status.ABORTED, status -> new ConcurrentLinkedQueue()).add(new TestAbortedException(reason));
                }

                public void executionFinished(TestDescriptor testDescriptor, TestExecutionResult testExecutionResult) {
                    Queue failures = ParameterizedFeatureChildExecutor.this.results.computeIfAbsent(testExecutionResult.getStatus(), status -> new ConcurrentLinkedQueue());
                    testExecutionResult.getThrowable().ifPresent(failures::add);
                }
            };
        }
    }

    public void execute(TestDescriptor testDescriptor) {
        this.executionCounter.incrementAndGet();
        this.parameterizedFeatureNode.addChild(testDescriptor);
        if (((FeatureInfo)this.parameterizedFeatureNode.getNodeInfo()).isReportIterations()) {
            this.delegate.execute(testDescriptor);
        } else {
            this.delegate.execute(testDescriptor, this.executionListener);
        }
    }

    public void awaitFinished() throws InterruptedException {
        this.delegate.awaitFinished();
    }

    int getExecutionCount() {
        return this.executionCounter.get();
    }

    Map<TestExecutionResult.Status, Queue<Throwable>> getResults() {
        return this.results;
    }
}

