/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime;

import groovy.lang.Closure;
import java.util.List;
import java.util.ListIterator;
import org.spockframework.runtime.Condition;
import org.spockframework.runtime.ConditionFailedWithExceptionError;
import org.spockframework.runtime.ConditionNotSatisfiedError;
import org.spockframework.runtime.ErrorCollector;
import org.spockframework.runtime.GroovyRuntimeUtil;
import org.spockframework.runtime.HamcrestFacade;
import org.spockframework.runtime.SpockAssertionError;
import org.spockframework.runtime.SpockException;
import org.spockframework.runtime.ValueRecorder;
import org.spockframework.runtime.model.ExpressionInfo;
import org.spockframework.runtime.model.TextPosition;
import org.spockframework.util.CollectionUtil;
import org.spockframework.util.ExceptionUtil;
import spock.util.matcher.HamcrestSupport;

public abstract class SpockRuntime {
    public static final String VERIFY_CONDITION = "verifyCondition";
    public static final String CONDITION_FAILED_WITH_EXCEPTION = "conditionFailedWithException";
    public static final String GROUP_CONDITION_FAILED_WITH_EXCEPTION = "groupConditionFailedWithException";
    public static final String VERIFY_METHOD_CONDITION = "verifyMethodCondition";
    public static final String DESPREAD_LIST = "despreadList";

    public static void verifyCondition(ErrorCollector errorCollector, ValueRecorder recorder, String text, int line, int column, Object message, Object condition) {
        if (!GroovyRuntimeUtil.isTruthy(condition)) {
            ConditionNotSatisfiedError conditionNotSatisfiedError = new ConditionNotSatisfiedError(new Condition(SpockRuntime.getValues(recorder), text, TextPosition.create(line, column), SpockRuntime.messageToString(message), null, null));
            errorCollector.collectOrThrow(conditionNotSatisfiedError);
        }
    }

    public static void conditionFailedWithException(ErrorCollector errorCollector, ValueRecorder recorder, String text, int line, int column, Object message, Throwable throwable) {
        if (throwable instanceof SpockAssertionError) {
            SpockAssertionError spockAssertionError = (SpockAssertionError)((Object)throwable);
            errorCollector.collectOrThrow(spockAssertionError);
            return;
        }
        if (throwable instanceof SpockException) {
            SpockException spockException = (SpockException)throwable;
            errorCollector.collectOrThrow(spockException);
            return;
        }
        ConditionFailedWithExceptionError conditionNotSatisfiedError = new ConditionFailedWithExceptionError(new Condition(SpockRuntime.getValues(recorder), text, TextPosition.create(line, column), SpockRuntime.messageToString(message), recorder == null ? null : recorder.getCurrentRecordingVarNum(), recorder == null ? null : throwable), throwable);
        errorCollector.collectOrThrow(conditionNotSatisfiedError);
    }

    public static void groupConditionFailedWithException(ErrorCollector errorCollector, Throwable throwable) {
        if (throwable instanceof AssertionError) {
            AssertionError assertionError = (AssertionError)((Object)throwable);
            errorCollector.collectOrThrow(assertionError);
            return;
        }
        if (throwable instanceof SpockException) {
            SpockException spockException = (SpockException)throwable;
            errorCollector.collectOrThrow(spockException);
            return;
        }
        ExceptionUtil.sneakyThrow(throwable);
    }

    public static void verifyMethodCondition(ErrorCollector errorCollector, ValueRecorder recorder, String text, int line, int column, Object message, Object target, String method, Object[] args, boolean safe, boolean explicit, int lastVariableNum) {
        Object result;
        MatcherCondition matcherCondition = MatcherCondition.parse(target, method, args, safe);
        if (matcherCondition != null) {
            matcherCondition.verify(errorCollector, SpockRuntime.getValues(recorder), text, line, column, SpockRuntime.messageToString(message));
            return;
        }
        if (recorder != null) {
            recorder.startRecordingValue(lastVariableNum);
        }
        Object object = result = safe ? GroovyRuntimeUtil.invokeMethodNullSafe(target, method, args) : GroovyRuntimeUtil.invokeMethod(target, method, args);
        if (!explicit && result == null && SpockRuntime.isVoidMethod(target, method, args)) {
            return;
        }
        if (!GroovyRuntimeUtil.isTruthy(result)) {
            List<Object> values = SpockRuntime.getValues(recorder);
            if (values != null) {
                CollectionUtil.setLastElement(values, result);
            }
            ConditionNotSatisfiedError conditionNotSatisfiedError = new ConditionNotSatisfiedError(new Condition(values, text, TextPosition.create(line, column), SpockRuntime.messageToString(message), null, null));
            errorCollector.collectOrThrow(conditionNotSatisfiedError);
        }
    }

    private static boolean isVoidMethod(Object target, String method, Object ... args) {
        if (target instanceof Closure) {
            Closure closure = (Closure)target;
            return GroovyRuntimeUtil.isVoidMethod(closure.getDelegate(), method, args) || SpockRuntime.isVoidMethod(closure.getOwner(), method, args);
        }
        return GroovyRuntimeUtil.isVoidMethod(target, method, args);
    }

    public static Object[] despreadList(Object[] args, Object[] spreads, int[] positions) {
        return GroovyRuntimeUtil.despreadList(args, spreads, positions);
    }

    private static List<Object> getValues(ValueRecorder recorder) {
        return recorder == null ? null : recorder.getValues();
    }

    private static String messageToString(Object message) {
        if (message == null) {
            return null;
        }
        return GroovyRuntimeUtil.toString(message);
    }

    private static class MatcherCondition {
        final Object actual;
        final Object matcher;
        final boolean shortSyntax;

        MatcherCondition(Object actual, Object matcher, boolean shortSyntax) {
            this.actual = actual;
            this.matcher = matcher;
            this.shortSyntax = shortSyntax;
        }

        void verify(ErrorCollector errorCollector, List<Object> values, String text, int line, int column, String message) {
            if (HamcrestFacade.matches(this.matcher, this.actual)) {
                return;
            }
            if (values != null) {
                CollectionUtil.setLastElement(values, this.shortSyntax ? this.actual : Boolean.valueOf(false));
                this.replaceMatcherValues(values);
            }
            String description = HamcrestFacade.getFailureDescription(this.matcher, this.actual, message);
            Condition condition = new Condition(values, text, TextPosition.create(line, column), description, null, null);
            errorCollector.collectOrThrow(new ConditionNotSatisfiedError(condition));
        }

        void replaceMatcherValues(List<Object> values) {
            boolean firstOccurrence = true;
            ListIterator<Object> iter = values.listIterator(values.size());
            while (iter.hasPrevious()) {
                Object value = iter.previous();
                if (!HamcrestFacade.isMatcher(value)) continue;
                if (firstOccurrence) {
                    iter.set(this.shortSyntax ? Boolean.valueOf(false) : ExpressionInfo.VALUE_NOT_AVAILABLE);
                    firstOccurrence = false;
                    continue;
                }
                iter.set(ExpressionInfo.VALUE_NOT_AVAILABLE);
            }
        }

        static MatcherCondition parse(Object target, String method, Object[] args, boolean safe) {
            if (safe) {
                return null;
            }
            if ("call".equals(method)) {
                if (args.length != 1 || !HamcrestFacade.isMatcher(args[0])) {
                    return null;
                }
                return new MatcherCondition(target, args[0], true);
            }
            if ("that".equals(method) || "expect".equals(method)) {
                if (target != HamcrestSupport.class) {
                    return null;
                }
                if (args.length != 2 || !HamcrestFacade.isMatcher(args[1])) {
                    return null;
                }
                return new MatcherCondition(args[0], args[1], false);
            }
            return null;
        }
    }
}

