/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime.extension.builtin;

import groovy.lang.Closure;
import groovy.lang.MissingPropertyException;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.Map;
import org.spockframework.runtime.GroovyRuntimeUtil;
import org.spockframework.runtime.extension.ExtensionException;
import org.spockframework.runtime.extension.IAnnotationDrivenExtension;
import org.spockframework.runtime.extension.IMethodInterceptor;
import org.spockframework.runtime.extension.IMethodInvocation;
import org.spockframework.runtime.extension.builtin.PreconditionContext;
import org.spockframework.runtime.model.FeatureInfo;
import org.spockframework.runtime.model.SpecInfo;

public abstract class ConditionalExtension<T extends Annotation>
implements IAnnotationDrivenExtension<T> {
    protected abstract Class<? extends Closure> getConditionClass(T var1);

    protected void specConditionResult(boolean result, T annotation, SpecInfo spec) {
        throw new UnsupportedOperationException();
    }

    protected void featureConditionResult(boolean result, T annotation, FeatureInfo feature) {
        throw new UnsupportedOperationException();
    }

    protected void iterationConditionResult(boolean result, T annotation, IMethodInvocation invocation) throws Throwable {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visitSpecAnnotation(T annotation, SpecInfo spec) {
        Closure condition = this.createCondition(annotation);
        Object result = ConditionalExtension.evaluateCondition(condition);
        this.specConditionResult(GroovyRuntimeUtil.isTruthy(result), annotation, spec);
    }

    @Override
    public void visitFeatureAnnotation(T annotation, FeatureInfo feature) {
        Closure condition = this.createCondition(annotation);
        try {
            Object result = ConditionalExtension.evaluateCondition(condition, feature.getSpec().getReflection());
            this.featureConditionResult(GroovyRuntimeUtil.isTruthy(result), annotation, feature);
        }
        catch (ExtensionException ee) {
            if (!(ee.getCause() instanceof MissingPropertyException)) {
                throw ee;
            }
            MissingPropertyException mpe = (MissingPropertyException)ee.getCause();
            if (!"instance".equals(mpe.getProperty()) && !feature.getDataVariables().contains(mpe.getProperty())) {
                throw ee;
            }
            feature.getFeatureMethod().addInterceptor(new IterationCondition(this, condition, annotation));
        }
    }

    private Closure createCondition(T annotation) {
        Class<Closure> clazz = this.getConditionClass(annotation);
        try {
            return clazz.getConstructor(Object.class, Object.class).newInstance(null, null);
        }
        catch (Exception e) {
            throw new ExtensionException("Failed to instantiate condition", e);
        }
    }

    private static Object evaluateCondition(Closure condition) {
        return ConditionalExtension.evaluateCondition(condition, null, Collections.emptyMap(), null);
    }

    private static Object evaluateCondition(Closure condition, Object instance, Map<String, Object> dataVariables) {
        return ConditionalExtension.evaluateCondition(condition, instance, dataVariables, null);
    }

    private static Object evaluateCondition(Closure condition, Object owner) {
        return ConditionalExtension.evaluateCondition(condition, null, Collections.emptyMap(), owner);
    }

    private static Object evaluateCondition(Closure condition, Object instance, Map<String, Object> dataVariables, Object owner) {
        PreconditionContext context = new PreconditionContext(instance, dataVariables);
        condition = condition.rehydrate((Object)context, owner, null);
        condition.setResolveStrategy(1);
        try {
            return condition.call((Object)context);
        }
        catch (Exception e) {
            throw new ExtensionException("Failed to evaluate condition", e);
        }
    }

    private static class IterationCondition
    implements IMethodInterceptor {
        private final Closure condition;
        private final T annotation;
        final /* synthetic */ ConditionalExtension this$0;

        public IterationCondition(Closure condition, T annotation) {
            this.this$0 = var1_1;
            this.condition = condition;
            this.annotation = annotation;
        }

        @Override
        public void intercept(IMethodInvocation invocation) throws Throwable {
            Object result = ConditionalExtension.evaluateCondition(this.condition, invocation.getInstance(), invocation.getIteration().getDataVariables());
            this.this$0.iterationConditionResult(GroovyRuntimeUtil.isTruthy(result), this.annotation, invocation);
            invocation.proceed();
        }
    }
}

