/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.compiler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.DynamicVariable;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ArrayExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.syntax.Token;
import org.spockframework.compiler.AstUtil;
import org.spockframework.compiler.IRewriteResources;
import org.spockframework.compiler.InstanceFieldAccessChecker;
import org.spockframework.compiler.InvalidSpecCompileException;
import org.spockframework.compiler.model.Method;
import org.spockframework.compiler.model.Spec;
import org.spockframework.compiler.model.WhereBlock;
import org.spockframework.util.ExceptionUtil;
import org.spockframework.util.InternalIdentifiers;
import org.spockframework.util.ObjectUtil;

public class WhereBlockRewriter {
    private final WhereBlock whereBlock;
    private final IRewriteResources resources;
    private final InstanceFieldAccessChecker instanceFieldAccessChecker;
    private int dataProviderCount = 0;
    private final List<VariableExpression> dataTableVars = new ArrayList<VariableExpression>();
    private final List<Parameter> dataProcessorParams = new ArrayList<Parameter>();
    private final List<Statement> dataProcessorStats = new ArrayList<Statement>();
    private final List<VariableExpression> dataProcessorVars = new ArrayList<VariableExpression>();
    private int localVariableCount = 0;

    private WhereBlockRewriter(WhereBlock whereBlock, IRewriteResources resources) {
        this.whereBlock = whereBlock;
        this.resources = resources;
        this.instanceFieldAccessChecker = new InstanceFieldAccessChecker(resources);
    }

    public static void rewrite(WhereBlock block, IRewriteResources resources) {
        new WhereBlockRewriter(block, resources).rewrite();
    }

    private void rewrite() {
        ListIterator<Statement> stats = ((List)this.whereBlock.getAst()).listIterator();
        while (stats.hasNext()) {
            try {
                this.rewriteWhereStat(stats);
            }
            catch (InvalidSpecCompileException e) {
                this.resources.getErrorReporter().error(e);
            }
        }
        ((List)this.whereBlock.getAst()).clear();
        this.handleFeatureParameters();
        this.createDataProcessorMethod();
    }

    private void rewriteWhereStat(ListIterator<Statement> stats) throws InvalidSpecCompileException {
        Statement stat = stats.next();
        BinaryExpression binExpr = AstUtil.getExpression(stat, BinaryExpression.class);
        if (binExpr != null) {
            if (binExpr.getClass() != BinaryExpression.class) {
                throw WhereBlockRewriter.notAParameterization((ASTNode)stat);
            }
            stats.previous();
            this.rewriteBinaryWhereStat(stats);
            return;
        }
        stats.previous();
        List<Expression> potentialHeaderRow = this.getExpressionChain(stats);
        potentialHeaderRow.stream().skip(1L).forEach(expression -> {
            Statement cfr_ignored_0 = (Statement)stats.previous();
        });
        if (potentialHeaderRow.size() > 1) {
            if (!potentialHeaderRow.stream().allMatch(VariableExpression.class::isInstance)) {
                throw WhereBlockRewriter.dataTableHeaderMayOnlyContainVariableNames((ASTNode)stat);
            }
            stats.previous();
            this.rewriteExpressionTableLikeParameterization(stats);
            return;
        }
        if (!AstUtil.isDataTableSeparator(stat)) {
            throw WhereBlockRewriter.notAParameterization((ASTNode)stat);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void rewriteBinaryWhereStat(ListIterator<Statement> stats) throws InvalidSpecCompileException {
        Statement stat = stats.next();
        BinaryExpression binExpr = AstUtil.getExpression(stat, BinaryExpression.class);
        int type = binExpr.getOperation().getType();
        if (type == 280) {
            Expression leftExpr = binExpr.getLeftExpression();
            if (leftExpr instanceof VariableExpression) {
                this.rewriteSimpleParameterization(binExpr, (ASTNode)stat, false);
                return;
            } else {
                if (!(leftExpr instanceof ListExpression)) throw WhereBlockRewriter.notAParameterization((ASTNode)stat);
                this.rewriteMultiParameterization(binExpr, stat);
            }
            return;
        } else if (type == 100) {
            Expression leftExpr = binExpr.getLeftExpression();
            if (leftExpr instanceof VariableExpression) {
                this.rewriteSimpleDerivedParameterization(binExpr, stat);
                return;
            } else {
                if (!(leftExpr instanceof TupleExpression)) throw WhereBlockRewriter.notAParameterization((ASTNode)stat);
                this.rewriteMultiDerivedParameterization(binExpr, stat);
            }
            return;
        } else {
            if (this.getOrExpression((Expression)binExpr) == null) throw WhereBlockRewriter.notAParameterization((ASTNode)stat);
            stats.previous();
            this.rewriteBinaryTableLikeParameterization(stats);
        }
    }

    private List<Expression> getExpressionChain(ListIterator<Statement> stats) {
        ArrayList<Expression> result = new ArrayList<Expression>();
        if (!stats.hasNext()) {
            return result;
        }
        Statement stat = stats.next();
        while (true) {
            Expression expr;
            if ((expr = AstUtil.getExpression(stat, Expression.class)) == null) {
                stats.previous();
                break;
            }
            result.add(expr);
            if (!stats.hasNext()) break;
            Statement nextStat = stats.next();
            if (nextStat.getLineNumber() != stat.getLastLineNumber()) {
                stats.previous();
                break;
            }
            stat = nextStat;
        }
        return result;
    }

    private void createDataProviderMethod(Expression dataProviderExpr, int nextDataVariableIndex, boolean addDataTableParameters) {
        this.instanceFieldAccessChecker.check(dataProviderExpr);
        ReturnStatement returnStat = new ReturnStatement(dataProviderExpr);
        returnStat.setSourcePosition((ASTNode)dataProviderExpr);
        MethodNode method = new MethodNode(InternalIdentifiers.getDataProviderName(((MethodNode)((Method)this.whereBlock.getParent()).getAst()).getName(), this.dataProviderCount++), 4097, ClassHelper.OBJECT_TYPE, addDataTableParameters ? this.createPreviousDataTableParameters(nextDataVariableIndex) : Parameter.EMPTY_ARRAY, ClassNode.EMPTY_ARRAY, (Statement)new BlockStatement(Arrays.asList(returnStat), null));
        method.addAnnotation(this.createDataProviderAnnotation(dataProviderExpr, nextDataVariableIndex, addDataTableParameters));
        ((ClassNode)((Spec)((Method)this.whereBlock.getParent()).getParent()).getAst()).addMethod(method);
    }

    private Parameter[] createPreviousDataTableParameters(int nextDataVariableIndex) {
        return (Parameter[])this.getPreviousDataTableVariables(nextDataVariableIndex).stream().map(previousDataTableVariable -> new Parameter(ClassHelper.LIST_TYPE.getPlainNodeReference(), this.getDataTableParameterName((String)previousDataTableVariable))).toArray(Parameter[]::new);
    }

    private List<String> getPreviousDataTableVariables(int nextDataVariableIndex) {
        ArrayList<String> results = new ArrayList<String>(nextDataVariableIndex);
        for (int i = 0; i < nextDataVariableIndex; ++i) {
            VariableExpression dataProcessorVar = this.dataProcessorVars.get(i);
            if (this.dataTableVars.stream().map(VariableExpression::getName).noneMatch(dataProcessorVar.getName()::equals)) continue;
            results.add(dataProcessorVar.getName());
        }
        return results;
    }

    private String getDataTableParameterName(String dataTableVariable) {
        return "$spock_p_" + dataTableVariable;
    }

    private AnnotationNode createDataProviderAnnotation(Expression dataProviderExpr, int nextDataVariableIndex, boolean addDataTableParameters) {
        AnnotationNode ann = new AnnotationNode(this.resources.getAstNodeCache().DataProviderMetadata);
        ann.addMember("line", (Expression)new ConstantExpression((Object)dataProviderExpr.getLineNumber()));
        ArrayList<ConstantExpression> dataVariableNames = new ArrayList<ConstantExpression>();
        for (int i = nextDataVariableIndex; i < this.dataProcessorVars.size(); ++i) {
            dataVariableNames.add(new ConstantExpression((Object)this.dataProcessorVars.get(i).getName()));
        }
        ann.addMember("dataVariables", (Expression)new ListExpression(dataVariableNames));
        if (addDataTableParameters) {
            ListExpression previousDataTableVariables = this.getPreviousDataTableVariables(nextDataVariableIndex).stream().map(ConstantExpression::new).collect(Collectors.collectingAndThen(Collectors.toList(), ListExpression::new));
            ann.addMember("previousDataTableVariables", (Expression)previousDataTableVariables);
        }
        return ann;
    }

    private Parameter createDataProcessorParameter() {
        Parameter p = new Parameter(ClassHelper.DYNAMIC_TYPE, "$spock_p" + this.dataProcessorParams.size());
        this.dataProcessorParams.add(p);
        return p;
    }

    private void rewriteSimpleParameterization(BinaryExpression binExpr, ASTNode sourcePos, boolean addDataTableParameters) throws InvalidSpecCompileException {
        int nextDataVariableIndex = this.dataProcessorVars.size();
        Parameter dataProcessorParameter = this.createDataProcessorParameter();
        VariableExpression arg = (VariableExpression)binExpr.getLeftExpression();
        VariableExpression dataVar = this.createDataProcessorVariable((Expression)arg, sourcePos);
        this.createDataProcessorStatement(dataVar, (Expression)new VariableExpression((Variable)dataProcessorParameter), sourcePos);
        this.createDataProviderMethod(binExpr.getRightExpression(), nextDataVariableIndex, addDataTableParameters);
    }

    private void rewriteMultiParameterization(BinaryExpression binExpr, Statement enclosingStat) throws InvalidSpecCompileException {
        int nextDataVariableIndex = this.dataProcessorVars.size();
        Parameter dataProcessorParameter = this.createDataProcessorParameter();
        ListExpression list = (ListExpression)binExpr.getLeftExpression();
        this.rewriteMultiParameterization(list, (Expression)new VariableExpression((Variable)dataProcessorParameter), enclosingStat);
        this.createDataProviderMethod(binExpr.getRightExpression(), nextDataVariableIndex, false);
    }

    private void rewriteMultiParameterization(ListExpression list, Expression rightBase, Statement enclosingStat) throws InvalidSpecCompileException {
        List listElems = list.getExpressions();
        for (int i = 0; i < listElems.size(); ++i) {
            VariableExpression variable;
            Expression listElem = (Expression)listElems.get(i);
            if (AstUtil.isWildcardRef(listElem)) continue;
            if (listElem instanceof VariableExpression) {
                variable = this.createDataProcessorVariable(listElem, (ASTNode)enclosingStat);
                this.createDataProcessorStatement(variable, (Expression)AstUtil.createGetAtMethodCall(rightBase, i), (ASTNode)enclosingStat);
                continue;
            }
            if (listElem instanceof ListExpression) {
                variable = new VariableExpression("$spock_l" + this.localVariableCount++);
                this.createDataProcessorStatement(variable, (Expression)AstUtil.createGetAtMethodCall(rightBase, i), (ASTNode)enclosingStat);
                this.rewriteMultiParameterization((ListExpression)listElem, (Expression)variable, enclosingStat);
                continue;
            }
            throw WhereBlockRewriter.notAParameterization((ASTNode)enclosingStat);
        }
    }

    private void rewriteSimpleDerivedParameterization(BinaryExpression parameterization, Statement enclosingStat) throws InvalidSpecCompileException {
        VariableExpression dataVar = this.createDataProcessorVariable(parameterization.getLeftExpression(), (ASTNode)enclosingStat);
        this.createDataProcessorStatement(dataVar, parameterization.getRightExpression(), (ASTNode)enclosingStat);
    }

    private void rewriteMultiDerivedParameterization(BinaryExpression binExpr, Statement enclosingStat) throws InvalidSpecCompileException {
        TupleExpression tuple = (TupleExpression)binExpr.getLeftExpression();
        VariableExpression rightExpression = new VariableExpression("$spock_l" + this.localVariableCount++);
        this.createDataProcessorStatement(rightExpression, binExpr.getRightExpression(), (ASTNode)enclosingStat);
        List tupleElems = tuple.getExpressions();
        for (int i = 0; i < tupleElems.size(); ++i) {
            Expression tupleElem = (Expression)tupleElems.get(i);
            if (AstUtil.isWildcardRef(tupleElem)) continue;
            VariableExpression dataVar = this.createDataProcessorVariable(tupleElem, (ASTNode)enclosingStat);
            this.createDataProcessorStatement(dataVar, (Expression)AstUtil.createGetAtMethodCall((Expression)rightExpression, i), (ASTNode)enclosingStat);
        }
    }

    private void createDataProcessorStatement(VariableExpression variable, Expression right, ASTNode sourcePos) {
        ExpressionStatement exprStat = new ExpressionStatement((Expression)new DeclarationExpression(variable, Token.newSymbol((int)100, (int)-1, (int)-1), right));
        exprStat.setSourcePosition(sourcePos);
        this.dataProcessorStats.add((Statement)exprStat);
    }

    private void rewriteBinaryTableLikeParameterization(ListIterator<Statement> stats) throws InvalidSpecCompileException {
        this.rewriteTableLikeParameterization(stats, result -> {
            Statement stat = (Statement)stats.next();
            BinaryExpression orExpr = this.getOrExpression(stat);
            if (orExpr == null) {
                stats.previous();
                return true;
            }
            this.splitRow((Expression)orExpr, (List<Expression>)result);
            return false;
        });
    }

    private void rewriteExpressionTableLikeParameterization(ListIterator<Statement> stats) throws InvalidSpecCompileException {
        this.rewriteTableLikeParameterization(stats, result -> {
            List<Expression> row = this.getExpressionChain(stats);
            if (row.size() <= 1) {
                row.forEach(expression -> {
                    Statement cfr_ignored_0 = (Statement)stats.previous();
                });
                return true;
            }
            result.addAll(row);
            return false;
        });
    }

    private void rewriteTableLikeParameterization(ListIterator<Statement> stats, Function<List<Expression>, Boolean> rowExtractor) throws InvalidSpecCompileException {
        ArrayList row;
        LinkedList<List<Expression>> rows = new LinkedList<List<Expression>>();
        while (stats.hasNext() && !rowExtractor.apply(row = new ArrayList()).booleanValue()) {
            if (rows.size() > 0 && rows.getLast().size() != row.size()) {
                throw new InvalidSpecCompileException((ASTNode)row.get(0), String.format("Row in data table has wrong number of elements (%s instead of %s)", row.size(), rows.getLast().size()), new Object[0]);
            }
            rows.add(row);
        }
        for (List<Expression> column : this.transposeTable(rows)) {
            this.turnIntoSimpleParameterization(column);
        }
    }

    List<List<Expression>> transposeTable(List<List<Expression>> rows) {
        ArrayList<List<Expression>> columns = new ArrayList<List<Expression>>();
        if (rows.isEmpty()) {
            return columns;
        }
        for (int i = 0; i < rows.get(0).size(); ++i) {
            columns.add(new ArrayList());
        }
        for (List<Expression> row : rows) {
            for (int i = 0; i < row.size(); ++i) {
                ((List)columns.get(i)).add(row.get(i));
            }
        }
        return columns;
    }

    private void turnIntoSimpleParameterization(List<Expression> column) throws InvalidSpecCompileException {
        VariableExpression varExpr = ObjectUtil.asInstance(column.get(0), VariableExpression.class);
        if (varExpr == null) {
            throw WhereBlockRewriter.dataTableHeaderMayOnlyContainVariableNames((ASTNode)column.get(0));
        }
        if (AstUtil.isWildcardRef((Expression)varExpr)) {
            return;
        }
        ListExpression listExpr = new ListExpression();
        List<String> previousVariables = this.getPreviousDataTableVariables(this.dataProcessorVars.size());
        if (previousVariables.isEmpty()) {
            column.stream().skip(1L).forEach(arg_0 -> ((ListExpression)listExpr).addExpression(arg_0));
        } else {
            int rows = column.size() - 1;
            for (int row = 0; row < rows; ++row) {
                Expression providerExpression = column.get(row + 1);
                providerExpression.visit((GroovyCodeVisitor)new DataProviderInternalsVerifier());
                List<String> referencedPreviousVariables = this.getReferencedPreviousVariables(previousVariables, providerExpression);
                if (referencedPreviousVariables.isEmpty()) {
                    listExpr.addExpression(providerExpression);
                    continue;
                }
                ArrayList<Statement> statements = new ArrayList<Statement>();
                this.generatePreviousColumnExtractorStatements(referencedPreviousVariables, row, statements);
                ReturnStatement providerStatement = new ReturnStatement(providerExpression);
                providerStatement.setSourcePosition((ASTNode)providerExpression);
                statements.add((Statement)providerStatement);
                ClosureExpression closureExpression = new ClosureExpression(Parameter.EMPTY_ARRAY, (Statement)new BlockStatement(statements, null));
                listExpr.addExpression((Expression)AstUtil.createDirectMethodCall((Expression)closureExpression, this.resources.getAstNodeCache().Closure_Call, (Expression)ArgumentListExpression.EMPTY_ARGUMENTS));
            }
        }
        BinaryExpression binExpr = new BinaryExpression((Expression)varExpr, Token.newSymbol((int)280, (int)-1, (int)-1), (Expression)listExpr);
        this.dataTableVars.add(new VariableExpression(varExpr.getName(), varExpr.getType()));
        this.rewriteSimpleParameterization(binExpr, (ASTNode)varExpr, true);
    }

    private void generatePreviousColumnExtractorStatements(List<String> referencedPreviousVariables, int row, List<Statement> statements) {
        for (String referencedPreviousVariable : referencedPreviousVariables) {
            statements.add((Statement)new ExpressionStatement((Expression)new DeclarationExpression(new VariableExpression(referencedPreviousVariable), Token.newSymbol((int)100, (int)-1, (int)-1), (Expression)AstUtil.createDirectMethodCall((Expression)new VariableExpression(this.getDataTableParameterName(referencedPreviousVariable)), this.resources.getAstNodeCache().List_Get, (Expression)new ConstantExpression((Object)row)))));
        }
    }

    private List<String> getReferencedPreviousVariables(List<String> previousVariables, Expression providerExpression) {
        return previousVariables.stream().map(PreviousDataTableVariableUsageTracker::new).peek(arg_0 -> ((Expression)providerExpression).visit(arg_0)).filter(PreviousDataTableVariableUsageTracker::hasFound).map(PreviousDataTableVariableUsageTracker::getVariable).collect(Collectors.toList());
    }

    private void splitRow(Expression row, List<Expression> parts) {
        BinaryExpression orExpr = this.getOrExpression(row);
        if (orExpr == null) {
            parts.add(row);
        } else {
            this.splitRow(orExpr.getLeftExpression(), parts);
            this.splitRow(orExpr.getRightExpression(), parts);
        }
    }

    private BinaryExpression getOrExpression(Statement stat) {
        Expression expr = AstUtil.getExpression(stat, Expression.class);
        return this.getOrExpression(expr);
    }

    private BinaryExpression getOrExpression(Expression expr) {
        BinaryExpression binExpr = ObjectUtil.asInstance(expr, BinaryExpression.class);
        if (binExpr == null) {
            return null;
        }
        int binExprType = binExpr.getOperation().getType();
        if (binExprType == 340 || binExprType == 162) {
            return binExpr;
        }
        return null;
    }

    private VariableExpression createDataProcessorVariable(Expression varExpr, ASTNode sourcePos) throws InvalidSpecCompileException {
        if (!(varExpr instanceof VariableExpression)) {
            throw WhereBlockRewriter.notAParameterization(sourcePos);
        }
        VariableExpression typedVarExpr = (VariableExpression)varExpr;
        this.verifyDataProcessorVariable(typedVarExpr);
        VariableExpression result = new VariableExpression(typedVarExpr.getName(), typedVarExpr.getType());
        this.dataProcessorVars.add(result);
        return result;
    }

    private void verifyDataProcessorVariable(VariableExpression varExpr) {
        Variable accessedVar = varExpr.getAccessedVariable();
        if (accessedVar instanceof VariableExpression) {
            this.resources.getErrorReporter().error((ASTNode)varExpr, "A variable named '%s' already exists in this scope", varExpr.getName());
            return;
        }
        if (this.isDataProcessorVariable(varExpr.getName())) {
            this.resources.getErrorReporter().error((ASTNode)varExpr, "Duplicate declaration of data variable '%s'", varExpr.getName());
        }
    }

    private boolean isDataProcessorVariable(String name) {
        for (VariableExpression var : this.dataProcessorVars) {
            if (!var.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    private void handleFeatureParameters() {
        Parameter[] parameters = ((MethodNode)((Method)this.whereBlock.getParent()).getAst()).getParameters();
        Map<Boolean, List<Parameter>> declaredParameters = Arrays.stream(parameters).collect(Collectors.partitioningBy(parameter -> this.isDataProcessorVariable(parameter.getName())));
        Map declaredDataVariableParameters = declaredParameters.get(Boolean.TRUE).stream().collect(Collectors.toMap(Parameter::getName, Function.identity()));
        List<Parameter> auxiliaryParameters = declaredParameters.get(Boolean.FALSE);
        ArrayList<Parameter> newParameters = new ArrayList<Parameter>(this.dataProcessorVars.size() + auxiliaryParameters.size());
        for (VariableExpression dataProcessorVar : this.dataProcessorVars) {
            String name = dataProcessorVar.getName();
            Parameter declaredDataVariableParameter = (Parameter)declaredDataVariableParameters.get(name);
            newParameters.add(declaredDataVariableParameter == null ? new Parameter(ClassHelper.DYNAMIC_TYPE, name) : declaredDataVariableParameter);
        }
        newParameters.addAll(auxiliaryParameters);
        ((MethodNode)((Method)this.whereBlock.getParent()).getAst()).setParameters(newParameters.toArray(Parameter.EMPTY_ARRAY));
    }

    private void createDataProcessorMethod() {
        if (this.dataProcessorVars.isEmpty()) {
            return;
        }
        this.dataProcessorStats.add((Statement)new ReturnStatement((Expression)new ArrayExpression(ClassHelper.OBJECT_TYPE, this.dataProcessorVars)));
        BlockStatement blockStat = new BlockStatement(this.dataProcessorStats, null);
        MethodNode dataProcessorMethod = new MethodNode(InternalIdentifiers.getDataProcessorName(((MethodNode)((Method)this.whereBlock.getParent()).getAst()).getName()), 4097, ClassHelper.OBJECT_TYPE, this.dataProcessorParams.toArray(Parameter.EMPTY_ARRAY), ClassNode.EMPTY_ARRAY, (Statement)blockStat);
        dataProcessorMethod.addAnnotation(this.createDataProcessorAnnotation());
        ((ClassNode)((Spec)((Method)this.whereBlock.getParent()).getParent()).getAst()).addMethod(dataProcessorMethod);
    }

    private AnnotationNode createDataProcessorAnnotation() {
        AnnotationNode ann = new AnnotationNode(this.resources.getAstNodeCache().DataProcessorMetadata);
        ann.addMember("dataVariables", (Expression)this.dataProcessorVars.stream().map(VariableExpression::getName).map(ConstantExpression::new).collect(Collectors.collectingAndThen(Collectors.toList(), ListExpression::new)));
        return ann;
    }

    private static InvalidSpecCompileException notAParameterization(ASTNode stat) {
        return new InvalidSpecCompileException(stat, "where-blocks may only contain parameterizations (e.g. 'salary << [1000, 5000, 9000]; salaryk = salary / 1000')", new Object[0]);
    }

    private static InvalidSpecCompileException dataTableHeaderMayOnlyContainVariableNames(ASTNode stat) {
        return new InvalidSpecCompileException(stat, "Header of data table may only contain variable names", new Object[0]);
    }

    private static class PreviousDataTableVariableUsageTracker
    extends ClassCodeVisitorSupport {
        private boolean found = false;
        private final String variable;

        public PreviousDataTableVariableUsageTracker(String variable) {
            this.variable = variable;
        }

        boolean hasFound() {
            return this.found;
        }

        String getVariable() {
            return this.variable;
        }

        protected SourceUnit getSourceUnit() {
            throw new UnsupportedOperationException("getSourceUnit");
        }

        public void visitVariableExpression(VariableExpression expression) {
            super.visitVariableExpression(expression);
            if ((expression.getAccessedVariable() instanceof DynamicVariable || expression.getAccessedVariable() instanceof Parameter) && expression.getName().equals(this.variable)) {
                this.found = true;
            }
        }
    }

    private static class DataProviderInternalsVerifier
    extends ClassCodeVisitorSupport {
        private DataProviderInternalsVerifier() {
        }

        protected SourceUnit getSourceUnit() {
            throw new UnsupportedOperationException("getSourceUnit");
        }

        public void visitVariableExpression(VariableExpression expression) {
            super.visitVariableExpression(expression);
            if (expression.getName().startsWith("$spock_p_")) {
                ExceptionUtil.sneakyThrow((Throwable)((Object)new InvalidSpecCompileException((ASTNode)expression, "You should not try to use Spock internals", new Object[0])));
            }
        }
    }
}

