/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ArrayExpression;
import org.codehaus.groovy.ast.expr.AttributeExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.BitwiseNegationExpression;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.CastExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ClosureListExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.ElvisOperatorExpression;
import org.codehaus.groovy.ast.expr.FieldExpression;
import org.codehaus.groovy.ast.expr.GStringExpression;
import org.codehaus.groovy.ast.expr.LambdaExpression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.MapEntryExpression;
import org.codehaus.groovy.ast.expr.MapExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.MethodPointerExpression;
import org.codehaus.groovy.ast.expr.MethodReferenceExpression;
import org.codehaus.groovy.ast.expr.NotExpression;
import org.codehaus.groovy.ast.expr.PostfixExpression;
import org.codehaus.groovy.ast.expr.PrefixExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.RangeExpression;
import org.codehaus.groovy.ast.expr.SpreadExpression;
import org.codehaus.groovy.ast.expr.SpreadMapExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.TernaryExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.UnaryMinusExpression;
import org.codehaus.groovy.ast.expr.UnaryPlusExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.classgen.BytecodeExpression;
import org.spockframework.compat.groovy2.GroovyCodeVisitorCompat;
import org.spockframework.runtime.model.ExpressionInfo;
import org.spockframework.runtime.model.TextPosition;
import org.spockframework.runtime.model.TextRegion;
import org.spockframework.util.AbstractExpressionConverter;

public class ExpressionInfoConverter
extends AbstractExpressionConverter<ExpressionInfo>
implements GroovyCodeVisitorCompat {
    private final String[] lines;

    public ExpressionInfoConverter(String[] lines) {
        this.lines = lines;
    }

    public void visitMethodCallExpression(MethodCallExpression expr) {
        TextPosition anchor = TextPosition.startOf((ASTNode)expr.getMethod());
        ArrayList<ExpressionInfo> children = new ArrayList<ExpressionInfo>();
        if (!expr.isImplicitThis()) {
            children.add((ExpressionInfo)this.convert(expr.getObjectExpression()));
        }
        children.add((ExpressionInfo)this.convert(expr.getMethod()));
        children.add((ExpressionInfo)this.convert(expr.getArguments()));
        this.result = new ExpressionInfo(TextRegion.of((ASTNode)expr), anchor, expr.getMethodAsString(), children);
    }

    public void visitBytecodeExpression(BytecodeExpression expr) {
        this.unsupported();
    }

    public void visitStaticMethodCallExpression(StaticMethodCallExpression expr) {
        this.unsupported();
    }

    public void visitConstructorCallExpression(ConstructorCallExpression expr) {
        this.result = new ExpressionInfo(TextRegion.of((ASTNode)expr), TextPosition.startOf((ASTNode)expr), "<init>", (ExpressionInfo)this.convert(expr.getArguments()));
    }

    public void visitArgumentlistExpression(ArgumentListExpression expr) {
        this.result = new ExpressionInfo(TextRegion.of((ASTNode)expr), TextPosition.startOf((ASTNode)expr), null, this.convertAll(expr.getExpressions())).setRelevant(false);
    }

    public void visitPropertyExpression(PropertyExpression expr) {
        this.result = new ExpressionInfo(TextRegion.of((ASTNode)expr), TextPosition.startOf((ASTNode)expr.getProperty()), expr.getPropertyAsString(), expr.isImplicitThis() ? Collections.emptyList() : Collections.singletonList(this.convert(expr.getObjectExpression())));
    }

    public void visitAttributeExpression(AttributeExpression expr) {
        this.visitPropertyExpression((PropertyExpression)expr);
    }

    public void visitFieldExpression(FieldExpression expr) {
        this.result = new ExpressionInfo(TextRegion.of((ASTNode)expr), TextPosition.startOf((ASTNode)expr), expr.getFieldName(), new ExpressionInfo[0]);
    }

    public void visitMethodPointerExpression(MethodPointerExpression expr) {
        this.result = new ExpressionInfo(TextRegion.of((ASTNode)expr), TextPosition.startOf((ASTNode)expr.getMethodName()), expr.getMethodName().getText(), (ExpressionInfo)this.convert(expr.getExpression()), (ExpressionInfo)this.convert(expr.getMethodName())).setRelevant(false);
    }

    @Override
    public void visitMethodReferenceExpression(MethodReferenceExpression expr) {
        this.visitMethodPointerExpression((MethodPointerExpression)expr);
    }

    public void visitVariableExpression(VariableExpression expr) {
        this.result = new ExpressionInfo(TextRegion.of((ASTNode)expr), TextPosition.startOf((ASTNode)expr), expr.getName(), new ExpressionInfo[0]).setRelevant(expr != VariableExpression.THIS_EXPRESSION && expr != VariableExpression.SUPER_EXPRESSION);
    }

    public void visitDeclarationExpression(DeclarationExpression expression) {
        this.unsupported();
    }

    public void visitConstantExpression(ConstantExpression expr) {
        this.result = new ExpressionInfo(TextRegion.of((ASTNode)expr), TextPosition.startOf((ASTNode)expr), expr.getConstantName(), new ExpressionInfo[0]).setRelevant(false);
    }

    public void visitClassExpression(ClassExpression expr) {
        this.result = new ExpressionInfo(TextRegion.of((ASTNode)expr), TextPosition.startOf((ASTNode)expr), null, new ExpressionInfo[0]);
    }

    public void visitBinaryExpression(BinaryExpression expr) {
        this.result = new ExpressionInfo(TextRegion.of((ASTNode)expr), expr.getOperation().getType() == 30 ? this.startOf("[", (ASTNode)expr.getRightExpression()) : TextPosition.startOf(expr.getOperation()), expr.getOperation().getText(), (ExpressionInfo)this.convert(expr.getLeftExpression()), (ExpressionInfo)this.convert(expr.getRightExpression()));
    }

    public void visitUnaryMinusExpression(UnaryMinusExpression expr) {
        this.result = new ExpressionInfo(TextRegion.of((ASTNode)expr), TextPosition.startOf((ASTNode)expr), "-", (ExpressionInfo)this.convert(expr.getExpression()));
    }

    public void visitUnaryPlusExpression(UnaryPlusExpression expr) {
        this.result = new ExpressionInfo(TextRegion.of((ASTNode)expr), TextPosition.startOf((ASTNode)expr), "+", (ExpressionInfo)this.convert(expr.getExpression()));
    }

    public void visitNotExpression(NotExpression expr) {
        this.result = new ExpressionInfo(TextRegion.of((ASTNode)expr), TextPosition.startOf((ASTNode)expr), "!", (ExpressionInfo)this.convert(expr.getExpression()));
    }

    public void visitBitwiseNegationExpression(BitwiseNegationExpression expr) {
        this.result = new ExpressionInfo(TextRegion.of((ASTNode)expr), TextPosition.startOf((ASTNode)expr), "^", (ExpressionInfo)this.convert(expr.getExpression()));
    }

    public void visitListExpression(ListExpression expr) {
        this.result = new ExpressionInfo(TextRegion.of((ASTNode)expr), TextPosition.startOf((ASTNode)expr), "[]", this.convertAll(expr.getExpressions())).setRelevant(false);
    }

    public void visitRangeExpression(RangeExpression expr) {
        this.result = new ExpressionInfo(TextRegion.of((ASTNode)expr), this.startOf("..", (ASTNode)expr.getTo()), "..", (ExpressionInfo)this.convert(expr.getFrom()), (ExpressionInfo)this.convert(expr.getTo())).setRelevant(false);
    }

    public void visitMapExpression(MapExpression expr) {
        this.result = new ExpressionInfo(TextRegion.of((ASTNode)expr), TextPosition.startOf((ASTNode)expr), "[:]", this.convertAll(expr.getMapEntryExpressions())).setRelevant(false);
    }

    public void visitMapEntryExpression(MapEntryExpression expr) {
        this.result = new ExpressionInfo(TextRegion.of((ASTNode)expr), this.startOf(":", (ASTNode)expr.getValueExpression()), null, (ExpressionInfo)this.convert(expr.getKeyExpression()), (ExpressionInfo)this.convert(expr.getValueExpression()));
    }

    public void visitGStringExpression(GStringExpression expr) {
        this.result = new ExpressionInfo(TextRegion.of((ASTNode)expr), TextPosition.startOf((ASTNode)expr), "\"\"", this.convertAll(expr.getValues())).setRelevant(false);
    }

    public void visitTernaryExpression(TernaryExpression expr) {
        this.result = new ExpressionInfo(TextRegion.of((ASTNode)expr), this.startOf("?", (ASTNode)expr.getTrueExpression()), "?:", this.convertAll(Arrays.asList(expr.getBooleanExpression(), expr.getTrueExpression(), expr.getFalseExpression()))).setRelevant(false);
    }

    public void visitShortTernaryExpression(ElvisOperatorExpression expr) {
        this.result = new ExpressionInfo(TextRegion.of((ASTNode)expr), this.startOf("?", (ASTNode)expr.getFalseExpression()), "?:", (ExpressionInfo)this.convert(expr.getTrueExpression()), (ExpressionInfo)this.convert(expr.getFalseExpression())).setRelevant(false);
    }

    public void visitPrefixExpression(PrefixExpression expr) {
        this.result = new ExpressionInfo(TextRegion.of((ASTNode)expr), TextPosition.startOf((ASTNode)expr), expr.getOperation().getText(), (ExpressionInfo)this.convert(expr.getExpression()));
    }

    public void visitPostfixExpression(PostfixExpression expr) {
        this.result = new ExpressionInfo(TextRegion.of((ASTNode)expr), TextPosition.startOf((ASTNode)expr), expr.getOperation().getText(), (ExpressionInfo)this.convert(expr.getExpression()));
    }

    public void visitBooleanExpression(BooleanExpression expr) {
        this.result = new ExpressionInfo(TextRegion.of((ASTNode)expr), TextPosition.startOf((ASTNode)expr), null, (ExpressionInfo)this.convert(expr.getExpression())).setRelevant(false);
    }

    public void visitClosureExpression(ClosureExpression expr) {
        this.result = new ExpressionInfo(TextRegion.of((ASTNode)expr), TextPosition.startOf((ASTNode)expr), "{->}", new ExpressionInfo[0]).setRelevant(false);
    }

    @Override
    public void visitLambdaExpression(LambdaExpression expr) {
        this.visitClosureExpression((ClosureExpression)expr);
    }

    public void visitTupleExpression(TupleExpression expr) {
        this.result = new ExpressionInfo(TextRegion.of((ASTNode)expr), TextPosition.startOf((ASTNode)expr), null, this.convertAll(expr.getExpressions())).setRelevant(false);
    }

    public void visitCastExpression(CastExpression expr) {
        this.result = new ExpressionInfo(TextRegion.of((ASTNode)expr), TextPosition.startOf((ASTNode)expr), "as", (ExpressionInfo)this.convert(expr.getExpression())).setRelevant(false);
    }

    public void visitClosureListExpression(ClosureListExpression expr) {
        this.unsupported();
    }

    public void visitArrayExpression(ArrayExpression expr) {
        List<ExpressionInfo> children = this.convertAll(expr.getExpressions());
        if (expr.getSizeExpression() != null) {
            children.addAll(this.convertAll(expr.getSizeExpression()));
        }
        this.result = new ExpressionInfo(TextRegion.of((ASTNode)expr), TextPosition.startOf((ASTNode)expr), null, children).setRelevant(false);
    }

    public void visitSpreadExpression(SpreadExpression expr) {
        this.result = new ExpressionInfo(TextRegion.of((ASTNode)expr), TextPosition.startOf((ASTNode)expr), "*", (ExpressionInfo)this.convert(expr.getExpression())).setRelevant(false);
    }

    public void visitSpreadMapExpression(SpreadMapExpression expr) {
        this.result = new ExpressionInfo(TextRegion.of((ASTNode)expr), TextPosition.startOf((ASTNode)expr), "*:", new ExpressionInfo[0]);
    }

    private TextPosition startOf(String token, ASTNode node) {
        int lastLineIndex;
        for (int lineIndex = lastLineIndex = Math.max(node.getLineNumber(), node.getLastLineNumber()) - 1; lineIndex >= 0; --lineIndex) {
            int columnIndex;
            int n = columnIndex = lineIndex == lastLineIndex ? this.lines[lineIndex].lastIndexOf(token, node.getColumnNumber() - 1) : this.lines[lineIndex].lastIndexOf(token);
            if (columnIndex == -1) continue;
            return TextPosition.create(lineIndex + 1, columnIndex + 1);
        }
        throw new IllegalArgumentException(String.format("token %s not found in expression", token));
    }
}

