/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime;

import java.lang.reflect.Method;
import java.util.Arrays;
import org.spockframework.runtime.IRunSupervisor;
import org.spockframework.runtime.ParameterizedFeatureChildExecutor;
import org.spockframework.runtime.SpecificationContext;
import org.spockframework.runtime.SpockExecutionContext;
import org.spockframework.runtime.extension.IMethodInterceptor;
import org.spockframework.runtime.extension.MethodInvocation;
import org.spockframework.runtime.model.ErrorInfo;
import org.spockframework.runtime.model.FeatureInfo;
import org.spockframework.runtime.model.IterationInfo;
import org.spockframework.runtime.model.MethodInfo;
import org.spockframework.runtime.model.MethodKind;
import org.spockframework.runtime.model.SpecInfo;
import org.spockframework.util.CollectionUtil;
import org.spockframework.util.InternalSpockError;
import spock.lang.Specification;

public class PlatformSpecRunner {
    protected final IRunSupervisor supervisor;

    public PlatformSpecRunner(IRunSupervisor supervisor) {
        this.supervisor = supervisor;
    }

    SpockExecutionContext runSharedSpec(SpockExecutionContext context) {
        context = this.createSpecInstance(context, true);
        this.runSharedInitializer(context);
        return context;
    }

    public void runSpec(SpockExecutionContext context, Runnable specRunner) {
        if (context.getErrorInfoCollector().hasErrors()) {
            return;
        }
        SpecInfo spec = context.getSpec();
        this.supervisor.beforeSpec(spec);
        this.invoke(context, this, this.createMethodInfoForDoRunSpec(context, specRunner), new Object[0]);
        this.supervisor.afterSpec(spec);
    }

    private MethodInfo createMethodInfoForDoRunSpec(SpockExecutionContext context, Runnable specRunner) {
        MethodInfo result = new MethodInfo((target, arguments) -> {
            specRunner.run();
            return null;
        });
        SpecInfo spec = context.getSpec();
        result.setParent(spec);
        result.setKind(MethodKind.SPEC_EXECUTION);
        for (IMethodInterceptor interceptor : spec.getInterceptors()) {
            result.addInterceptor(interceptor);
        }
        return result;
    }

    SpockExecutionContext createSpecInstance(SpockExecutionContext context, boolean shared) {
        Specification instance;
        if (context.getErrorInfoCollector().hasErrors()) {
            return context;
        }
        try {
            instance = (Specification)((Class)context.getSpec().getReflection()).newInstance();
        }
        catch (Throwable t) {
            throw new InternalSpockError("Failed to instantiate spec '%s'", t).withArgs(context.getSpec().getName());
        }
        context = context.withCurrentInstance(instance);
        this.getSpecificationContext(context).setCurrentSpec(context.getSpec());
        if (shared) {
            context = context.withSharedInstance(instance);
        }
        this.getSpecificationContext(context).setSharedInstance(context.getSharedInstance());
        return context;
    }

    private void runSharedInitializer(SpockExecutionContext context) {
        this.runSharedInitializer(context, context.getSpec());
    }

    private void runSharedInitializer(SpockExecutionContext context, SpecInfo spec) {
        if (spec == null) {
            return;
        }
        this.invoke(context, this, this.createMethodInfoForDoRunSharedInitializer(context, spec), spec);
    }

    private MethodInfo createMethodInfoForDoRunSharedInitializer(SpockExecutionContext context, SpecInfo spec) {
        MethodInfo result = new MethodInfo((target, arguments) -> {
            this.doRunSharedInitializer(context, spec);
            return null;
        });
        result.setParent(spec);
        result.setKind(MethodKind.SHARED_INITIALIZER);
        for (IMethodInterceptor interceptor : spec.getSharedInitializerInterceptors()) {
            result.addInterceptor(interceptor);
        }
        return result;
    }

    public void doRunSharedInitializer(SpockExecutionContext context, SpecInfo spec) {
        this.runSharedInitializer(context, spec.getSuperSpec());
        if (context.getErrorInfoCollector().hasErrors()) {
            return;
        }
        this.invoke(context, context.getCurrentInstance(), spec.getSharedInitializerMethod(), new Object[0]);
    }

    void runSetupSpec(SpockExecutionContext context) {
        this.supervisor.beforeSpec(context.getSpec());
        this.runSetupSpec(context, context.getSpec());
    }

    private void runSetupSpec(SpockExecutionContext context, SpecInfo spec) {
        if (spec == null) {
            return;
        }
        this.invoke(context, this, this.createMethodInfoForDoRunSetupSpec(context, spec), spec);
    }

    private MethodInfo createMethodInfoForDoRunSetupSpec(SpockExecutionContext context, SpecInfo spec) {
        MethodInfo result = new MethodInfo((target, arguments) -> {
            this.doRunSetupSpec(context, spec);
            return null;
        });
        result.setParent(spec);
        result.setKind(MethodKind.SETUP_SPEC);
        for (IMethodInterceptor interceptor : spec.getSetupSpecInterceptors()) {
            result.addInterceptor(interceptor);
        }
        return result;
    }

    public void doRunSetupSpec(SpockExecutionContext context, SpecInfo spec) {
        this.runSetupSpec(context, spec.getSuperSpec());
        for (MethodInfo method : spec.getSetupSpecMethods()) {
            if (context.getErrorInfoCollector().hasErrors()) {
                return;
            }
            this.invoke(context, context.getCurrentInstance(), method, new Object[0]);
        }
    }

    void runCleanupSpec(SpockExecutionContext context) {
        this.runCleanupSpec(context.withCurrentInstance(context.getSharedInstance()), context.getSpec());
        this.supervisor.afterSpec(context.getSpec());
    }

    private void runCleanupSpec(SpockExecutionContext context, SpecInfo spec) {
        if (spec == null) {
            return;
        }
        this.invoke(context, this, this.createMethodForDoRunCleanupSpec(context, spec), spec);
    }

    private MethodInfo createMethodForDoRunCleanupSpec(SpockExecutionContext context, SpecInfo spec) {
        MethodInfo result = new MethodInfo((target, arguments) -> {
            this.doRunCleanupSpec(context, spec);
            return null;
        });
        result.setParent(spec);
        result.setKind(MethodKind.CLEANUP_SPEC);
        for (IMethodInterceptor interceptor : spec.getCleanupSpecInterceptors()) {
            result.addInterceptor(interceptor);
        }
        return result;
    }

    public void doRunCleanupSpec(SpockExecutionContext context, SpecInfo spec) {
        for (MethodInfo method : spec.getCleanupSpecMethods()) {
            this.invoke(context, context.getCurrentInstance(), method, new Object[0]);
        }
        this.runCleanupSpec(context, spec.getSuperSpec());
    }

    public void runFeature(SpockExecutionContext context, Runnable feature) {
        if (context.getErrorInfoCollector().hasErrors()) {
            return;
        }
        FeatureInfo currentFeature = context.getCurrentFeature();
        if (currentFeature.isExcluded()) {
            return;
        }
        if (currentFeature.isSkipped()) {
            this.supervisor.featureSkipped(currentFeature);
            return;
        }
        this.supervisor.beforeFeature(currentFeature);
        this.invoke(context, this, this.createMethodInfoForDoRunFeature(context, feature), new Object[0]);
        this.supervisor.afterFeature(currentFeature);
    }

    private MethodInfo createMethodInfoForDoRunFeature(SpockExecutionContext context, Runnable feature) {
        FeatureInfo currentFeature = context.getCurrentFeature();
        MethodInfo result = new MethodInfo((target, arguments) -> {
            feature.run();
            return null;
        });
        result.setParent(currentFeature.getParent());
        result.setKind(MethodKind.FEATURE_EXECUTION);
        result.setFeature(currentFeature);
        for (IMethodInterceptor interceptor : currentFeature.getInterceptors()) {
            result.addInterceptor(interceptor);
        }
        return result;
    }

    void runIteration(SpockExecutionContext context, IterationInfo iterationInfo, Runnable runnable) {
        if (context.getErrorInfoCollector().hasErrors()) {
            return;
        }
        context = context.withCurrentIteration(iterationInfo);
        this.getSpecificationContext(context).setCurrentIteration(iterationInfo);
        this.supervisor.beforeIteration(iterationInfo);
        this.invoke(context, this, this.createMethodInfoForDoRunIteration(context, runnable), new Object[0]);
        this.supervisor.afterIteration(iterationInfo);
        this.getSpecificationContext(context).setCurrentIteration(null);
    }

    IterationInfo createIterationInfo(SpockExecutionContext context, int iterationIndex, Object[] dataValues, int estimatedNumIterations) {
        FeatureInfo currentFeature = context.getCurrentFeature();
        IterationInfo result = new IterationInfo(currentFeature, iterationIndex, dataValues, estimatedNumIterations);
        String iterationName = currentFeature.getIterationNameProvider().getName(result);
        result.setName(iterationName);
        return result;
    }

    private MethodInfo createMethodInfoForDoRunIteration(SpockExecutionContext context, Runnable runnable) {
        FeatureInfo currentFeature = context.getCurrentFeature();
        MethodInfo result = new MethodInfo((target, arguments) -> {
            runnable.run();
            return null;
        });
        result.setParent(currentFeature.getParent());
        result.setKind(MethodKind.ITERATION_EXECUTION);
        result.setFeature(currentFeature);
        result.setIteration(context.getCurrentIteration());
        for (IMethodInterceptor interceptor : currentFeature.getIterationInterceptors()) {
            result.addInterceptor(interceptor);
        }
        return result;
    }

    void runParameterizedFeature(SpockExecutionContext context, ParameterizedFeatureChildExecutor childExecutor) throws InterruptedException {
        throw new UnsupportedOperationException("This runner cannot run parameterized features");
    }

    void runInitializer(SpockExecutionContext context) {
        this.runInitializer(context, context.getSpec());
    }

    private void runInitializer(SpockExecutionContext context, SpecInfo spec) {
        if (spec == null) {
            return;
        }
        this.invoke(context, this, this.createMethodInfoForDoRunInitializer(context, spec), spec);
    }

    private MethodInfo createMethodInfoForDoRunInitializer(SpockExecutionContext context, SpecInfo spec) {
        FeatureInfo currentFeature = context.getCurrentFeature();
        MethodInfo result = new MethodInfo((target, arguments) -> {
            this.doRunInitializer(context, spec);
            return null;
        });
        result.setParent(currentFeature.getParent());
        result.setKind(MethodKind.INITIALIZER);
        result.setFeature(currentFeature);
        for (IMethodInterceptor interceptor : spec.getInitializerInterceptors()) {
            result.addInterceptor(interceptor);
        }
        return result;
    }

    public void doRunInitializer(SpockExecutionContext context, SpecInfo spec) {
        this.runInitializer(context, spec.getSuperSpec());
        if (context.getErrorInfoCollector().hasErrors()) {
            return;
        }
        this.invoke(context, context.getCurrentInstance(), spec.getInitializerMethod(), new Object[0]);
    }

    void runSetup(SpockExecutionContext context) {
        this.runSetup(context, context.getSpec());
    }

    private void runSetup(SpockExecutionContext context, SpecInfo spec) {
        if (spec == null) {
            return;
        }
        this.invoke(context, this, this.createMethodInfoForDoRunSetup(context, spec), spec);
    }

    private MethodInfo createMethodInfoForDoRunSetup(SpockExecutionContext context, SpecInfo spec) {
        FeatureInfo currentFeature = context.getCurrentFeature();
        MethodInfo result = new MethodInfo((target, arguments) -> {
            this.doRunSetup(context, spec);
            return null;
        });
        result.setParent(currentFeature.getParent());
        result.setKind(MethodKind.SETUP);
        result.setFeature(currentFeature);
        result.setIteration(context.getCurrentIteration());
        for (IMethodInterceptor interceptor : spec.getSetupInterceptors()) {
            result.addInterceptor(interceptor);
        }
        return result;
    }

    private void doRunSetup(SpockExecutionContext context, SpecInfo spec) {
        this.runSetup(context, spec.getSuperSpec());
        for (MethodInfo method : spec.getSetupMethods()) {
            if (context.getErrorInfoCollector().hasErrors()) {
                return;
            }
            method.setFeature(context.getCurrentFeature());
            this.invoke(context, context.getCurrentInstance(), method, new Object[0]);
        }
    }

    void runFeatureMethod(SpockExecutionContext context) {
        if (context.getErrorInfoCollector().hasErrors()) {
            return;
        }
        MethodInfo featureIteration = new MethodInfo(context.getCurrentFeature().getFeatureMethod());
        featureIteration.setIteration(context.getCurrentIteration());
        Class<?>[] parameterTypes = ((Method)featureIteration.getReflection()).getParameterTypes();
        int parameterCount = parameterTypes.length;
        Object[] dataValues = context.getCurrentIteration().getDataValues();
        Object[] iterationArguments = new Object[parameterCount];
        System.arraycopy(dataValues, 0, iterationArguments, 0, dataValues.length);
        Arrays.fill(iterationArguments, dataValues.length, parameterCount, MethodInfo.MISSING_ARGUMENT);
        this.invoke(context, context.getCurrentInstance(), featureIteration, iterationArguments);
    }

    void runCleanup(SpockExecutionContext context) {
        this.runCleanup(context, context.getSpec());
    }

    private void runCleanup(SpockExecutionContext context, SpecInfo spec) {
        if (spec == null) {
            return;
        }
        this.invoke(context, this, this.createMethodInfoForDoRunCleanup(context, spec), spec);
    }

    private MethodInfo createMethodInfoForDoRunCleanup(SpockExecutionContext context, SpecInfo spec) {
        FeatureInfo currentFeature = context.getCurrentFeature();
        MethodInfo result = new MethodInfo((target, arguments) -> {
            this.doRunCleanup(context, spec);
            return null;
        });
        result.setParent(currentFeature.getParent());
        result.setKind(MethodKind.CLEANUP);
        result.setFeature(currentFeature);
        result.setIteration(context.getCurrentIteration());
        for (IMethodInterceptor interceptor : spec.getCleanupInterceptors()) {
            result.addInterceptor(interceptor);
        }
        return result;
    }

    private void doRunCleanup(SpockExecutionContext context, SpecInfo spec) {
        if (spec.getIsBottomSpec()) {
            this.runIterationCleanups(context);
        }
        for (MethodInfo method : spec.getCleanupMethods()) {
            this.invoke(context, context.getCurrentInstance(), method, new Object[0]);
        }
        this.runCleanup(context, spec.getSuperSpec());
    }

    private void runIterationCleanups(SpockExecutionContext context) {
        for (Runnable cleanup : context.getCurrentIteration().getCleanups()) {
            try {
                cleanup.run();
            }
            catch (Throwable t) {
                ErrorInfo error = new ErrorInfo(CollectionUtil.getFirstElement(context.getSpec().getCleanupMethods()), t);
                this.supervisor.error(context.getErrorInfoCollector(), error);
            }
        }
    }

    protected void invoke(SpockExecutionContext context, Object target, MethodInfo method, Object ... arguments) {
        if (method == null || method.isExcluded()) {
            return;
        }
        if (method.getInterceptors().isEmpty()) {
            this.invokeRaw(context, target, method, arguments);
            return;
        }
        MethodInvocation invocation = new MethodInvocation(context.getCurrentFeature(), context.getCurrentIteration(), context.getSharedInstance(), context.getCurrentInstance(), target, method, arguments);
        try {
            invocation.proceed();
        }
        catch (Throwable throwable) {
            ErrorInfo error = new ErrorInfo(method, throwable);
            this.supervisor.error(context.getErrorInfoCollector(), error);
        }
    }

    protected Object invokeRaw(SpockExecutionContext context, Object target, MethodInfo method, Object ... arguments) {
        try {
            return method.invoke(target, arguments);
        }
        catch (Throwable throwable) {
            this.supervisor.error(context.getErrorInfoCollector(), new ErrorInfo(method, throwable));
            return null;
        }
    }

    protected SpecificationContext getSpecificationContext(SpockExecutionContext context) {
        return (SpecificationContext)context.getCurrentInstance().getSpecificationContext();
    }
}

