/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime.extension.builtin;

import groovy.lang.Closure;
import java.util.ArrayList;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.opentest4j.MultipleFailuresError;
import org.spockframework.runtime.extension.IMethodInterceptor;
import org.spockframework.runtime.extension.IMethodInvocation;
import org.spockframework.runtime.extension.builtin.RetryBaseInterceptor;
import spock.lang.Retry;

public class RetryIterationInterceptor
extends RetryBaseInterceptor
implements IMethodInterceptor {
    public RetryIterationInterceptor(Retry retry) {
        super(retry);
    }

    @Override
    public void intercept(IMethodInvocation invocation) throws Throwable {
        ArrayList<Throwable> throwableList = new ArrayList<Throwable>();
        ConcurrentLinkedQueue<Throwable> throwables = new ConcurrentLinkedQueue<Throwable>();
        for (int i = 0; i <= this.retry.count(); ++i) {
            throwables.clear();
            invocation.getFeature().getFeatureMethod().addInterceptor(new InnerRetryInterceptor(this.retry, this.condition, throwables));
            invocation.proceed();
            if (throwables.isEmpty()) {
                throwableList.clear();
                break;
            }
            throwableList.addAll(throwables);
            if (this.retry.delay() <= 0) continue;
            Thread.sleep(this.retry.delay());
        }
        if (!throwableList.isEmpty()) {
            throw new MultipleFailuresError("Retries exhausted", throwableList);
        }
    }

    static class InnerRetryInterceptor
    extends RetryBaseInterceptor
    implements IMethodInterceptor {
        private final Queue<Throwable> throwables;

        public InnerRetryInterceptor(Retry retry, Closure condition, Queue<Throwable> throwables) {
            super(retry, condition);
            this.throwables = throwables;
        }

        @Override
        public void intercept(IMethodInvocation invocation) throws Throwable {
            try {
                invocation.proceed();
            }
            catch (Throwable e) {
                if (this.isExpected(invocation, e)) {
                    this.throwables.add(e);
                }
                throw e;
            }
        }
    }
}

