/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.spockframework.util.InternalSpockError;
import org.spockframework.util.VersionNumber;

public class SpockReleaseInfo {
    private static final VersionNumber version;
    private static final VersionNumber minGroovyVersion;
    private static final VersionNumber maxGroovyVersion;

    public static VersionNumber getVersion() {
        return version;
    }

    public static VersionNumber getMinGroovyVersion() {
        return minGroovyVersion;
    }

    public static VersionNumber getMaxGroovyVersion() {
        return maxGroovyVersion;
    }

    public static boolean isCompatibleGroovyVersion(VersionNumber groovyVersion) {
        if (minGroovyVersion.equals(VersionNumber.UNKNOWN) || maxGroovyVersion.equals(VersionNumber.UNKNOWN) || groovyVersion.equals(VersionNumber.UNKNOWN)) {
            return true;
        }
        return minGroovyVersion.compareTo(groovyVersion) <= 0 && maxGroovyVersion.compareTo(groovyVersion) >= 0;
    }

    public static String getArtifactPath() {
        return SpockReleaseInfo.class.getProtectionDomain().getCodeSource().getLocation().toString();
    }

    static {
        Properties properties = new Properties();
        try (InputStream stream = SpockReleaseInfo.class.getResourceAsStream("SpockReleaseInfo.properties");){
            properties.load(stream);
        }
        catch (IOException e) {
            throw new InternalSpockError("Failed to load `SpockReleaseInfo.properties`", e);
        }
        version = VersionNumber.parse(properties.getProperty("version"));
        minGroovyVersion = VersionNumber.parse(properties.getProperty("minGroovyVersion"));
        maxGroovyVersion = VersionNumber.parse(properties.getProperty("maxGroovyVersion"));
    }
}

