/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime;

import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.hierarchical.EngineExecutionContext;
import org.spockframework.runtime.ErrorInfoCollector;
import org.spockframework.runtime.PlatformParameterizedSpecRunner;
import org.spockframework.runtime.RunContext;
import org.spockframework.runtime.model.FeatureInfo;
import org.spockframework.runtime.model.IterationInfo;
import org.spockframework.runtime.model.SpecInfo;
import org.spockframework.util.InternalSpockError;
import spock.lang.Specification;

public class SpockExecutionContext
implements EngineExecutionContext,
Cloneable {
    private EngineExecutionListener engineExecutionListener;
    private RunContext runContext;
    private PlatformParameterizedSpecRunner runner;
    private SpecInfo spec;
    private FeatureInfo currentFeature;
    private IterationInfo currentIteration;
    private Specification sharedInstance;
    private Specification currentInstance;
    private UniqueId parentId;
    private ErrorInfoCollector errorInfoCollector;

    public SpockExecutionContext(EngineExecutionListener engineExecutionListener) {
        this.engineExecutionListener = engineExecutionListener;
    }

    private SpockExecutionContext setRunContext(RunContext runContext) {
        this.runContext = runContext;
        return this;
    }

    private SpockExecutionContext setRunner(PlatformParameterizedSpecRunner runner) {
        this.runner = runner;
        return this;
    }

    private SpockExecutionContext setSpec(SpecInfo spec) {
        this.spec = spec;
        return this;
    }

    private SpockExecutionContext setCurrentFeature(FeatureInfo currentFeature) {
        this.currentFeature = currentFeature;
        return this;
    }

    private SpockExecutionContext setCurrentIteration(IterationInfo currentIteration) {
        this.currentIteration = currentIteration;
        return this;
    }

    private SpockExecutionContext setSharedInstance(Specification sharedInstance) {
        this.sharedInstance = sharedInstance;
        return this;
    }

    private SpockExecutionContext setCurrentInstance(Specification currentInstance) {
        this.currentInstance = currentInstance;
        return this;
    }

    public SpockExecutionContext setParentId(UniqueId parentId) {
        this.parentId = parentId;
        return this;
    }

    public SpockExecutionContext setErrorInfoCollector(ErrorInfoCollector errorInfoCollector) {
        this.errorInfoCollector = errorInfoCollector;
        return this;
    }

    protected SpockExecutionContext clone() {
        try {
            return (SpockExecutionContext)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalSpockError("Could not clone context", e);
        }
    }

    public PlatformParameterizedSpecRunner getRunner() {
        return this.runner;
    }

    public RunContext getRunContext() {
        return this.runContext;
    }

    public SpockExecutionContext withRunContext(RunContext runContext) {
        return this.clone().setRunContext(runContext);
    }

    public SpockExecutionContext withRunner(PlatformParameterizedSpecRunner runner) {
        return this.clone().setRunner(runner);
    }

    public SpockExecutionContext withSharedInstance(Specification sharedInstance) {
        return this.clone().setSharedInstance(sharedInstance);
    }

    public SpockExecutionContext withCurrentInstance(Specification currentInstance) {
        return this.clone().setCurrentInstance(currentInstance);
    }

    SpockExecutionContext withSpec(SpecInfo spec) {
        return this.clone().setSpec(spec);
    }

    public SpockExecutionContext withCurrentFeature(FeatureInfo feature) {
        return this.clone().setCurrentFeature(feature);
    }

    public SpockExecutionContext withCurrentIteration(IterationInfo iteration) {
        return this.clone().setCurrentFeature(iteration.getFeature()).setCurrentIteration(iteration);
    }

    public SpockExecutionContext withErrorInfoCollector(ErrorInfoCollector errorInfoCollector) {
        return this.clone().setErrorInfoCollector(errorInfoCollector);
    }

    public SpockExecutionContext withParentId(UniqueId uniqueId) {
        return this.clone().setParentId(uniqueId);
    }

    public Specification getSharedInstance() {
        return this.sharedInstance;
    }

    public Specification getCurrentInstance() {
        return this.currentInstance;
    }

    public SpecInfo getSpec() {
        return this.spec;
    }

    public FeatureInfo getCurrentFeature() {
        return this.currentFeature;
    }

    public IterationInfo getCurrentIteration() {
        return this.currentIteration;
    }

    public UniqueId getParentId() {
        return this.parentId;
    }

    public ErrorInfoCollector getErrorInfoCollector() {
        return this.errorInfoCollector;
    }
}

