/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime.extension.builtin;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.spockframework.runtime.extension.IAnnotationDrivenExtension;
import org.spockframework.runtime.extension.builtin.ConfineMetaClassChangesInterceptor;
import org.spockframework.runtime.model.FeatureInfo;
import org.spockframework.runtime.model.IInterceptable;
import org.spockframework.runtime.model.SpecInfo;
import org.spockframework.runtime.model.parallel.ExclusiveResource;
import org.spockframework.runtime.model.parallel.ResourceAccessMode;
import spock.util.mop.ConfineMetaClassChanges;

public class ConfineMetaClassChangesExtension
implements IAnnotationDrivenExtension<ConfineMetaClassChanges> {
    private static final ExclusiveResource EXCLUSIVE_RESOURCE = new ExclusiveResource("groovy.lang.GroovySystem.metaClassRegistry", ResourceAccessMode.READ_WRITE);

    @Override
    public void visitSpecAnnotations(List<ConfineMetaClassChanges> annotations, SpecInfo spec) {
        this.addInterceptor(annotations, spec.getBottomSpec());
        spec.getBottomSpec().addExclusiveResource(EXCLUSIVE_RESOURCE);
    }

    @Override
    public void visitFeatureAnnotations(List<ConfineMetaClassChanges> annotations, FeatureInfo feature) {
        this.addInterceptor(annotations, feature.getFeatureMethod());
        feature.addExclusiveResource(EXCLUSIVE_RESOURCE);
    }

    private void addInterceptor(List<ConfineMetaClassChanges> annotations, IInterceptable interceptable) {
        interceptable.addInterceptor(new ConfineMetaClassChangesInterceptor(annotations.stream().map(ConfineMetaClassChanges::value).flatMap(Arrays::stream).collect(Collectors.toSet())));
    }
}

