/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime.extension.builtin;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.regex.Pattern;
import org.codehaus.groovy.runtime.ResourceGroovyMethods;
import org.spockframework.runtime.extension.IMethodInterceptor;
import org.spockframework.runtime.extension.IMethodInvocation;
import org.spockframework.runtime.model.FieldInfo;

public class TempDirInterceptor
implements IMethodInterceptor {
    private static final String TEMP_DIR_PREFIX = "spock";
    private static final Pattern VALID_CHARS = Pattern.compile("[^a-zA-Z0-9_.-]++");
    private final Class<?> fieldType;
    private final FieldInfo fieldInfo;
    private final Path parentDir;
    private final boolean keep;

    TempDirInterceptor(Class<?> fieldType, FieldInfo fieldInfo, Path parentDir, boolean keep) {
        this.fieldType = fieldType;
        this.fieldInfo = fieldInfo;
        this.parentDir = parentDir;
        this.keep = keep;
    }

    private String dirPrefix(IMethodInvocation invocation) {
        StringBuilder prefix = new StringBuilder(TEMP_DIR_PREFIX);
        prefix.append('_');
        String displayName = invocation.getIteration() == null ? invocation.getSpec().getDisplayName() : invocation.getIteration().getDisplayName();
        prefix.append(VALID_CHARS.matcher(displayName).replaceAll("_"));
        if (prefix.length() > 25) {
            prefix.setLength(25);
        }
        if (invocation.getIteration() != null) {
            prefix.append('_').append(invocation.getIteration().getIterationIndex());
        }
        return prefix.append('_').append(this.fieldInfo.getName()).toString();
    }

    private Path generateTempDir(IMethodInvocation invocation) throws IOException {
        String prefix = this.dirPrefix(invocation);
        if (this.parentDir == null) {
            return Files.createTempDirectory(prefix, new FileAttribute[0]);
        }
        return Files.createTempDirectory(this.parentDir, prefix, new FileAttribute[0]);
    }

    protected Path setUp(IMethodInvocation invocation) throws IOException {
        Path tempPath = this.generateTempDir(invocation);
        this.fieldInfo.writeValue(invocation.getInstance(), this.fieldType.isAssignableFrom(Path.class) ? tempPath : tempPath.toFile());
        return tempPath;
    }

    protected void destroy(Path path) throws IOException {
        if (!this.keep) {
            this.deleteTempDir(path);
        }
    }

    @Override
    public void intercept(IMethodInvocation invocation) throws Throwable {
        Path path = this.setUp(invocation);
        try {
            invocation.proceed();
        }
        finally {
            this.destroy(path);
        }
    }

    private void deleteTempDir(Path tempPath) throws IOException {
        if (Files.notExists(tempPath, new LinkOption[0])) {
            return;
        }
        if (ResourceGroovyMethods.deleteDir((File)tempPath.toFile())) {
            return;
        }
        this.tryMakeWritable(tempPath);
        ResourceGroovyMethods.deleteDir((File)tempPath.toFile());
    }

    private void tryMakeWritable(Path tempPath) throws IOException {
        Files.walkFileTree(tempPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                file.toFile().setWritable(true);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                dir.toFile().setWritable(true);
                return FileVisitResult.CONTINUE;
            }
        });
    }
}

