/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.mock;

import org.spockframework.mock.DefaultInteraction;
import org.spockframework.mock.IMockInvocation;

class DefaultToStringInteraction
extends DefaultInteraction {
    public static final DefaultToStringInteraction INSTANCE = new DefaultToStringInteraction();

    private DefaultToStringInteraction() {
    }

    @Override
    public String getText() {
        return "Object.toString() interaction";
    }

    @Override
    public boolean matches(IMockInvocation invocation) {
        return "toString".equals(invocation.getMethod().getName()) && invocation.getMethod().getParameterTypes().isEmpty();
    }

    @Override
    public Object accept(IMockInvocation invocation) {
        StringBuilder builder = new StringBuilder();
        builder.append("Mock for type '");
        builder.append(invocation.getMockObject().getType().getSimpleName());
        builder.append("'");
        String name = invocation.getMockObject().getName();
        if (name != null) {
            builder.append(" named '");
            builder.append(name);
            builder.append("'");
        }
        return builder.toString();
    }
}

