/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.mock.constraint;

import org.spockframework.mock.IArgumentConstraint;
import org.spockframework.runtime.Condition;
import org.spockframework.util.CollectionUtil;

public class TypeArgumentConstraint
implements IArgumentConstraint {
    private final Class<?> type;
    private final IArgumentConstraint constraint;

    public TypeArgumentConstraint(Class<?> type, IArgumentConstraint constraint) {
        this.type = type;
        this.constraint = constraint;
    }

    @Override
    public boolean isSatisfiedBy(Object argument) {
        return this.type.isInstance(argument) && this.constraint.isSatisfiedBy(argument);
    }

    @Override
    public String describeMismatch(Object argument) {
        if (this.type.isInstance(argument)) {
            return this.constraint.describeMismatch(argument);
        }
        Condition condition = new Condition(CollectionUtil.listOf(argument, this.type, false), String.format("argument instanceof %s", this.type.getName()), null, null, null, null);
        return condition.getRendering();
    }
}

