/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime.extension.builtin;

import org.spockframework.runtime.extension.IAnnotationDrivenExtension;
import org.spockframework.runtime.extension.builtin.RetryFeatureInterceptor;
import org.spockframework.runtime.extension.builtin.RetryIterationInterceptor;
import org.spockframework.runtime.model.FeatureInfo;
import org.spockframework.runtime.model.NodeInfo;
import org.spockframework.runtime.model.SpecInfo;
import spock.lang.Retry;

public class RetryExtension
implements IAnnotationDrivenExtension<Retry> {
    @Override
    public void visitSpecAnnotation(Retry annotation, SpecInfo spec) {
        if (this.noSubSpecWithRetryAnnotation(spec.getSubSpec())) {
            for (FeatureInfo feature : spec.getBottomSpec().getAllFeatures()) {
                if (!this.noRetryAnnotation(feature.getFeatureMethod())) continue;
                this.visitFeatureAnnotation(annotation, feature);
            }
        }
    }

    private boolean noSubSpecWithRetryAnnotation(SpecInfo spec) {
        if (spec == null) {
            return true;
        }
        return this.noRetryAnnotation(spec) && this.noSubSpecWithRetryAnnotation(spec.getSubSpec());
    }

    private boolean noRetryAnnotation(NodeInfo node) {
        return !node.getReflection().isAnnotationPresent(Retry.class);
    }

    @Override
    public void visitFeatureAnnotation(Retry annotation, FeatureInfo feature) {
        if (annotation.mode() == Retry.Mode.SETUP_FEATURE_CLEANUP) {
            feature.addIterationInterceptor(new RetryIterationInterceptor(annotation, feature.getFeatureMethod()));
        } else {
            feature.getFeatureMethod().addInterceptor(new RetryFeatureInterceptor(annotation));
        }
    }
}

